% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{Logger}
\alias{Logger}
\title{Simple logging utility}
\description{
Creates Logger object which can be used for logging with different level of
verbosity. Log messages are in JSON format.
}
\examples{
# init logger
logger = Logger$new("info")
# write info message
logger$info("hello world")
# write extended log entry
logger$info("", context = list(message = "hello world", code = 0L))

}
\seealso{
\link[lgr:Logger]{lgr::Logger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Logger$new()}}
\item \href{#method-set_name}{\code{Logger$set_name()}}
\item \href{#method-set_log_level}{\code{Logger$set_log_level()}}
\item \href{#method-set_printer}{\code{Logger$set_printer()}}
\item \href{#method-trace}{\code{Logger$trace()}}
\item \href{#method-debug}{\code{Logger$debug()}}
\item \href{#method-info}{\code{Logger$info()}}
\item \href{#method-warn}{\code{Logger$warn()}}
\item \href{#method-error}{\code{Logger$error()}}
\item \href{#method-fatal}{\code{Logger$fatal()}}
\item \href{#method-clone}{\code{Logger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates Logger object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$new(
  level = c("info", "fatal", "error", "warn", "debug", "trace", "off", "all"),
  name = "ROOT",
  printer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{Log level. Allowed values: info, fatal, error, warn, debug,
trace, off, all.}

\item{\code{name}}{Logger name.}

\item{\code{printer}}{Logger with sink defined by \code{printer} function.
It should have signature \verb{function(timestamp, level, logger_name, pid, message)}.
By default when \code{printer = NULL} logger writes message in JSON format to \code{stdout}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_name"></a>}}
\if{latex}{\out{\hypertarget{method-set_name}{}}}
\subsection{Method \code{set_name()}}{
Sets logger name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$set_name(name = "ROOT")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Logger name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_log_level"></a>}}
\if{latex}{\out{\hypertarget{method-set_log_level}{}}}
\subsection{Method \code{set_log_level()}}{
Sets log level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$set_log_level(
  level = c("info", "fatal", "error", "warn", "debug", "trace", "off", "all")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{Log level. Allowed values: info, fatal, error, warn, debug,
trace, off, all.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_printer"></a>}}
\if{latex}{\out{\hypertarget{method-set_printer}{}}}
\subsection{Method \code{set_printer()}}{
Sets function which defines how to print logs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$set_printer(FUN = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FUN}}{Printer function. Should be a function with 6 formal arguments:
timestamp, level, logger_name, pid, message.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trace"></a>}}
\if{latex}{\out{\hypertarget{method-trace}{}}}
\subsection{Method \code{trace()}}{
Write trace message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$trace(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-debug"></a>}}
\if{latex}{\out{\hypertarget{method-debug}{}}}
\subsection{Method \code{debug()}}{
Write debug message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$debug(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-info"></a>}}
\if{latex}{\out{\hypertarget{method-info}{}}}
\subsection{Method \code{info()}}{
Write information message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$info(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-warn"></a>}}
\if{latex}{\out{\hypertarget{method-warn}{}}}
\subsection{Method \code{warn()}}{
Write warning message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$warn(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-error"></a>}}
\if{latex}{\out{\hypertarget{method-error}{}}}
\subsection{Method \code{error()}}{
Write error message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$error(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fatal"></a>}}
\if{latex}{\out{\hypertarget{method-fatal}{}}}
\subsection{Method \code{fatal()}}{
Write fatal error message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$fatal(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Log message.}

\item{\code{...}}{Additionals params.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
