% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Require-helpers.R
\name{parseGitHub}
\alias{parseGitHub}
\title{Parse a github package specification}
\usage{
parseGitHub(pkgDT, verbose = getOption("Require.verbose"))
}
\arguments{
\item{pkgDT}{A pkgDT data.table.}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, the return object will have an
attribute: \code{attr(.., "Require")} which has lots of information about the
processes of the installs.}
}
\value{
\code{parseGitHub} returns a \code{data.table} with added columns.
}
\description{
This converts a specification like \code{PredictiveEcology/Require@development}
into separate columns, "Account", "Repo", "Branch", "GitSubFolder" (if there is one)
}
\details{
\code{parseGitHub} turns the single character string representation into 3 or 4:
\code{Account}, \code{Repo}, \code{Branch}, \code{SubFolder}.
}
