/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Part
extends Base {
    protected static Logger log = LoggerFactory.getLogger(Part.class);
    protected OpcPackage pack;
    private List<Relationship> sourceRelationships = new ArrayList<Relationship>();
    private String relationshipType;
    private RelationshipsPart owningRelationshipPart;
    private long contentLengthAsLoaded = -1L;
    private long version;

    public List<Relationship> getSourceRelationships() {
        return this.sourceRelationships;
    }

    @Deprecated
    public Relationship getSourceRelationship() {
        return this.sourceRelationships.get(0);
    }

    @Deprecated
    public void setSourceRelationship(Relationship sourceRelationship) {
        this.sourceRelationships.clear();
        this.sourceRelationships.add(sourceRelationship);
    }

    public String getRelationshipType() {
        if (this.relationshipType == null) {
            if (this.sourceRelationships.size() == 0) {
                log.warn(this.partName.getName() + " has no source rel set");
                return null;
            }
            return this.sourceRelationships.get(0).getType();
        }
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public RelationshipsPart getOwningRelationshipPart() {
        return this.owningRelationshipPart;
    }

    public void setOwningRelationshipPart(RelationshipsPart owningRelationshipPart) {
        this.owningRelationshipPart = owningRelationshipPart;
    }

    public long getContentLengthAsLoaded() {
        return this.contentLengthAsLoaded;
    }

    protected void setContentLengthAsLoaded(long contentLengthAsLoaded) {
        this.contentLengthAsLoaded = contentLengthAsLoaded;
    }

    public Part() {
    }

    public Part(PartName partName) throws InvalidFormatException {
        this.partName = partName;
    }

    public Part(PartName partName, String contentType) throws InvalidFormatException {
        this(partName);
        this.contentType = new ContentType(contentType);
    }

    @Override
    public OpcPackage getPackage() {
        if (this.pack == null) {
            log.error("Package field null for this Part " + this.getClass().getName());
        }
        return this.pack;
    }

    public void setPackage(OpcPackage pack) {
        log.debug("setPackage called for " + this.getClass().getName());
        this.pack = pack;
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        return false;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setPartName(PartName newName) {
        log.info("Renaming part " + this.getPartName().getName() + " to " + newName.getName());
        this.getPackage().getParts().remove(this.getPartName());
        URI tobeRelativized = newName.getURI();
        URI relativizeAgainst = this.getOwningRelationshipPart().getSourceURI();
        log.debug("Relativising target " + tobeRelativized + " against source " + relativizeAgainst);
        String result = URIHelper.relativizeURI(relativizeAgainst, tobeRelativized).toString();
        if (relativizeAgainst.getPath().equals("/") && result.startsWith("/")) {
            result = result.substring(1);
        }
        log.debug("Result " + result);
        for (Relationship rel : this.sourceRelationships) {
            rel.setTarget(result);
        }
        this.partName = newName;
        this.getPackage().getParts().put(this);
    }

    public abstract boolean isContentEqual(Part var1) throws Docx4JException;
}

