/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.convert.out.fo.LayoutMasterSetBuilder;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.CTTwipsMeasure;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltFOFunctions {
    public static DocumentFragment getLayoutMasterSetFragment(AbstractWmlConversionContext context) {
        return LayoutMasterSetBuilder.getLayoutMasterSetFragment(context);
    }

    public static DocumentFragment createBlockForSdt(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String tag) {
        Node foBlock;
        DocumentFragment docfrag = XsltFOFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, true);
        if (tag.equals("XSLT_Shd") && docfrag != null && (foBlock = docfrag.getFirstChild()) != null) {
            ((Element)foBlock).setAttribute("margin-top", "0in");
            ((Element)foBlock).setAttribute("margin-bottom", "0in");
        }
        return docfrag;
    }

    public static DocumentFragment createInlineForSdt(FOConversionContext context, NodeIterator rPrNodeIt, NodeIterator childResults, String tag) {
        DocumentFragment docfrag = XsltFOFunctions.createBlockForRPr(context, null, rPrNodeIt, childResults);
        return docfrag;
    }

    public static DocumentFragment createBlockForPPr(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        return XsltFOFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, false);
    }

    private static DocumentFragment createBlock(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, boolean sdt) {
        PropertyResolver propertyResolver = context.getPropertyResolver();
        Style defaultParagraphStyle = context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null ? context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        String defaultParagraphStyleId = defaultParagraphStyle == null ? "Normal" : defaultParagraphStyle.getStyleId();
        if (pStyleVal == null || pStyleVal.equals("")) {
            pStyleVal = defaultParagraphStyleId;
        }
        if (context.getLog().isDebugEnabled()) {
            context.getLog().debug("style '" + pStyleVal);
        }
        try {
            Node n;
            Element foBlockElement;
            PPr pPrDirect = null;
            PPr pPr = null;
            RPr rPr = null;
            if (pPrNodeIt == null) {
                if (context.getLog().isDebugEnabled()) {
                    context.getLog().debug("Here after all!!");
                }
                pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
            } else {
                Node n2 = pPrNodeIt.nextNode();
                if (n2 == null) {
                    if (context.getLog().isDebugEnabled()) {
                        context.getLog().debug("pPrNodeIt.nextNode() was null (ie there is no pPr in this p)");
                    }
                    pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                    rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
                } else {
                    if (context.getLog().isDebugEnabled()) {
                        context.getLog().debug("P actual pPr: " + XmlUtils.w3CDomNodeToString(n2));
                    }
                    Unmarshaller u = Context.jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                    Object jaxb = u.unmarshal(n2);
                    pPrDirect = (PPr)jaxb;
                    pPr = propertyResolver.getEffectivePPr(pPrDirect);
                    if (pPr == null && context.getLog().isDebugEnabled()) {
                        context.getLog().debug("pPr null; obtained from: " + XmlUtils.w3CDomNodeToString(n2));
                    }
                    if (context.getLog().isDebugEnabled()) {
                        context.getLog().debug("getting rPr for paragraph style");
                    }
                    rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
                }
            }
            if (context.getLog().isDebugEnabled() && pPr != null) {
                context.getLog().debug("P effective pPr: " + XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().newDocument();
            boolean indentHandledByNumbering = false;
            Element foListBlock = null;
            if (pPr != null && pPr.getNumPr() != null && pPr.getNumPr().getNumId() != null && pPr.getNumPr().getNumId().getVal().longValue() != 0L) {
                Emulator.ResultTriple triple;
                foListBlock = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-block");
                document.appendChild(foListBlock);
                if (pPr.getShd() != null) {
                    PShading pShading = new PShading(pPr.getShd());
                    pShading.setXslFO(foListBlock);
                }
                Element foListItem = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item");
                foListBlock.appendChild(foListItem);
                Element foListItemLabel = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-label");
                foListItem.appendChild(foListItemLabel);
                Element foListItemLabelBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemLabel.appendChild(foListItemLabelBody);
                if (pPrDirect != null && pPrDirect.getNumPr() != null) {
                    triple = Emulator.getNumber(context.getWmlPackage(), pStyleVal, pPrDirect.getNumPr().getNumId().getVal().toString(), pPrDirect.getNumPr().getIlvl().getVal().toString());
                } else {
                    PPrBase.NumPr.Ilvl ilvl = pPr.getNumPr().getIlvl();
                    String ilvlString = ilvl == null ? "0" : ilvl.getVal().toString();
                    triple = null;
                    if (pPr.getNumPr().getNumId() != null) {
                        triple = Emulator.getNumber(context.getWmlPackage(), pStyleVal, pPr.getNumPr().getNumId().getVal().toString(), ilvlString);
                    }
                }
                if (triple == null) {
                    context.getLog().warn("computed number ResultTriple was null");
                    if (context.getLog().isDebugEnabled()) {
                        foListItemLabelBody.setAttribute("color", "red");
                        foListItemLabelBody.setTextContent("null#");
                    }
                } else {
                    String font;
                    int numChars = 1;
                    if (triple.getBullet() != null) {
                        foListItemLabelBody.setTextContent(triple.getBullet());
                    } else if (triple.getNumString() == null) {
                        context.getLog().debug("computed NumString was null!");
                        if (context.getLog().isDebugEnabled()) {
                            foListItemLabelBody.setAttribute("color", "red");
                            foListItemLabelBody.setTextContent("null#");
                        }
                        numChars = 0;
                    } else {
                        Text number = document.createTextNode(triple.getNumString());
                        foListItemLabelBody.appendChild(number);
                        numChars = triple.getNumString().length();
                    }
                    Indent indent = new Indent(pPrDirect.getInd(), triple.getIndent());
                    if (indent.isHanging()) {
                        indent.setXslFOListBlock(foListBlock, -1);
                    } else {
                        int numWidth = 90 * numChars;
                        int pdbs = XsltFOFunctions.getDistanceToNextTabStop(context, indent.getNumberPosition(), numWidth, pPrDirect.getTabs(), context.getWmlPackage().getMainDocumentPart().getDocumentSettingsPart());
                        indent.setXslFOListBlock(foListBlock, pdbs);
                    }
                    indentHandledByNumbering = true;
                    if (triple.getNumFont() != null && (font = PhysicalFonts.getPhysicalFont(context.getWmlPackage(), triple.getNumFont())) != null) {
                        foListItemLabelBody.setAttribute("font-family", font);
                    }
                }
                Element foListItemBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-body");
                foListItem.appendChild(foListItemBody);
                foListItemBody.setAttribute("start-indent", "body-start()");
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemBody.appendChild(foBlockElement);
                if (context.getLog().isDebugEnabled()) {
                    context.getLog().debug("bare list result: " + XmlUtils.w3CDomNodeToString(foListBlock));
                }
            } else {
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                document.appendChild(foBlockElement);
            }
            if (pPr != null) {
                boolean ignoreBorders = !sdt;
                XsltFOFunctions.createFoAttributes(context.getWmlPackage(), pPr, foBlockElement, indentHandledByNumbering, ignoreBorders);
            }
            if (rPr != null) {
                if (foListBlock == null) {
                    XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foBlockElement);
                } else {
                    XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foListBlock);
                }
            }
            if (context.getLog().isDebugEnabled()) {
                context.getLog().debug("after createFoAttributes: " + XmlUtils.w3CDomNodeToString(foBlockElement));
            }
            if ((n = childResults.nextNode()).getChildNodes().getLength() == 0) {
                foBlockElement.setAttribute("white-space-treatment", "preserve");
                foBlockElement.setTextContent(" ");
            } else {
                XmlUtils.treeCopy(n, (Node)foBlockElement);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            context.getLog().error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private static int getDistanceToNextTabStop(FOConversionContext context, int pos, int numWidth, Tabs pprTabs, DocumentSettingsPart settings) {
        CTTwipsMeasure twips;
        boolean pdbs = false;
        int defaultTab = 360;
        if (pprTabs != null && pprTabs.getTab() != null && pprTabs.getTab().size() > 0) {
            for (CTTabStop tabStop : pprTabs.getTab()) {
                if (tabStop.getPos().intValue() <= pos + numWidth) continue;
                context.getLog().debug("tab stop: using specified");
                return tabStop.getPos().intValue() - pos;
            }
        }
        if (settings != null && ((CTSettings)settings.getJaxbElement()).getDefaultTabStop() != null && (defaultTab = (twips = ((CTSettings)settings.getJaxbElement()).getDefaultTabStop()).getVal().intValue()) > 0) {
            context.getLog().debug("tab stop: using default from docx");
            int tabNUmber = (int)Math.floor((pos + numWidth) / defaultTab);
            int nextTabPos = defaultTab * (tabNUmber + 1);
            return nextTabPos - pos;
        }
        context.getLog().debug("tab stop: assuming default tab 360");
        int tabNUmber = (int)Math.floor((pos + numWidth) / defaultTab);
        int nextTabPos = defaultTab * (tabNUmber + 1);
        return nextTabPos - pos;
    }

    private static void createFoAttributes(OpcPackage opcPackage, PPr pPr, Element foBlockElement, boolean inList, boolean ignoreBorders) {
        List<Property> properties = PropertyFactory.createProperties(opcPackage, pPr);
        for (Property p : properties) {
            if (p == null || ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (inList && !(p instanceof Indent)) {
                p.setXslFO(foBlockElement);
                continue;
            }
            if (inList) continue;
            p.setXslFO(foBlockElement);
        }
    }

    public static void applyFoAttributes(List<Property> properties, Element foElement) {
        if (properties != null && !properties.isEmpty()) {
            for (int i = 0; i < properties.size(); ++i) {
                properties.get(i).setXslFO(foElement);
            }
        }
    }

    private static void createFoAttributes(TrPr trPr, Element foBlockElement) {
        if (trPr == null) {
            return;
        }
        XsltFOFunctions.applyFoAttributes(PropertyFactory.createProperties(trPr), foBlockElement);
    }

    private static void createFoAttributes(TcPr tcPr, Element foBlockElement) {
        if (tcPr == null) {
            return;
        }
        XsltFOFunctions.applyFoAttributes(PropertyFactory.createProperties(tcPr), foBlockElement);
    }

    public static DocumentFragment createBlockForRPr(FOConversionContext context, NodeIterator pPrNodeIt, NodeIterator rPrNodeIt, NodeIterator childResults) {
        PropertyResolver propertyResolver = context.getPropertyResolver();
        try {
            Node n;
            Unmarshaller u = Context.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            PPr pPrDirect = null;
            if (pPrNodeIt != null && (n = pPrNodeIt.nextNode()) != null) {
                Object jaxb = u.unmarshal(n);
                try {
                    pPrDirect = (PPr)jaxb;
                }
                catch (ClassCastException e) {
                    context.getLog().error("Couldn't cast " + jaxb.getClass().getName() + " to PPr!");
                }
            }
            Object jaxbR = u.unmarshal(rPrNodeIt.nextNode());
            RPr rPrDirect = null;
            try {
                rPrDirect = (RPr)jaxbR;
            }
            catch (ClassCastException e) {
                context.getLog().error("Couldn't cast ..");
            }
            RPr rPr = propertyResolver.getEffectiveRPr(rPrDirect, pPrDirect);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().newDocument();
            Element foInlineElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            document.appendChild(foInlineElement);
            XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foInlineElement);
            Node n2 = childResults.nextNode();
            XmlUtils.treeCopy(n2, (Node)foInlineElement);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            context.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void createFoAttributes(OpcPackage opcPackage, RPr rPr, Element foInlineElement) {
        List<Property> properties = PropertyFactory.createProperties(opcPackage, rPr);
        for (Property p : properties) {
            p.setXslFO(foInlineElement);
        }
    }

    public static String getPageNumberFormat(FOConversionContext context) {
        String pageFormat = context.getSections().getCurrentSection().getPageNumberInformation().getPageFormat();
        return (pageFormat = FormattingSwitchHelper.getFoPageNumberFormat(pageFormat)) == null ? "" : pageFormat;
    }

    public static String getPageNumberInitial(FOConversionContext context) {
        int ret = context.getSections().getCurrentSection().getPageNumberInformation().getPageStart();
        return ret == -1 ? "" : Integer.toString(ret);
    }

    public static boolean hasPgNumTypeStart(FOConversionContext context) {
        return context.getSections().getCurrentSection().getPageNumberInformation().getPageStart() > -1;
    }
}

