/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.LineEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.format.DiffXFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class ShortStringFormatter
implements DiffXFormatter {
    private final Writer out;

    public ShortStringFormatter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public ShortStringFormatter(Writer w) throws IOException {
        this.out = w;
    }

    public void format(DiffXEvent e) throws IOException, IllegalStateException {
        this.out.write(ShortStringFormatter.toShortString(e));
    }

    public void insert(DiffXEvent e) throws IOException, IllegalStateException {
        this.out.write("+");
        this.out.write(ShortStringFormatter.toShortString(e));
    }

    public void delete(DiffXEvent e) throws IOException, IllegalStateException {
        this.out.write("-");
        this.out.write(ShortStringFormatter.toShortString(e));
    }

    public void setConfig(DiffXConfig config) {
    }

    public static String toShortString(DiffXEvent e) {
        if (e instanceof OpenElementEvent) {
            return '<' + ((OpenElementEvent)e).getName() + '>';
        }
        if (e instanceof CloseElementEvent) {
            return "</" + ((CloseElementEvent)e).getName() + '>';
        }
        if (e instanceof AttributeEvent) {
            return "@" + ((AttributeEvent)e).getName();
        }
        if (e instanceof WordEvent) {
            return '\"' + ((CharactersEventBase)e).getCharacters() + '\"';
        }
        if (e instanceof SpaceEvent) {
            return "_s_";
        }
        if (e instanceof CharEvent) {
            return '\'' + ((CharactersEventBase)e).getCharacters() + '\'';
        }
        if (e instanceof IgnorableSpaceEvent) {
            return "_i_";
        }
        if (e instanceof LineEvent) {
            return "L#" + ((LineEvent)e).getLineNumber();
        }
        return "???";
    }
}

