/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.fo.PlaceholderReplacementHandler;
import org.docx4j.utils.FoNumberFormatUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPlaceholderLookup
implements PlaceholderReplacementHandler.PlaceholderLookup {
    protected static final String PLACEHOLDER_PREFIX = "${";
    protected static final String PLACEHOLDER_SUFFIX = "}";
    protected static final int PLACEHOLDER_PREFIX_LENGTH = "${".length();
    protected static final int PLACEHOLDER_SUFFIX_LENGTH = "}".length();
    protected static final String FIRST_PASS_DUMMY_VALUE = "00";
    protected List<FORenderer.SectionPageInformation> pageNumberInformation = null;
    protected Map<String, String> placeholderValues = new TreeMap<String, String>();

    protected AbstractPlaceholderLookup(List<FORenderer.SectionPageInformation> pageNumberInformation) {
        this.pageNumberInformation = this.setupPageNumerInformation(pageNumberInformation);
    }

    protected List<FORenderer.SectionPageInformation> setupPageNumerInformation(List<FORenderer.SectionPageInformation> pageNumberInformation) {
        FORenderer.SectionPageInformation item = null;
        this.placeholderValues.clear();
        for (int i = 0; i < pageNumberInformation.size(); ++i) {
            item = pageNumberInformation.get(i);
            this.putValue(item.getDocumentPageCountID(), FIRST_PASS_DUMMY_VALUE);
            this.putValue(item.getSectionPageCountID(), FIRST_PASS_DUMMY_VALUE);
        }
        return pageNumberInformation;
    }

    protected void putDocumentPageCount(int pageCount) {
        String pageCountValue = null;
        String foFormat = null;
        String lastFoFormat = null;
        FORenderer.SectionPageInformation item = null;
        for (int i = 0; i < this.pageNumberInformation.size(); ++i) {
            item = this.pageNumberInformation.get(i);
            foFormat = item.getDocumentPageCountFoFormat();
            if (!foFormat.equals(lastFoFormat)) {
                pageCountValue = FoNumberFormatUtil.format(pageCount, foFormat);
                lastFoFormat = foFormat;
            }
            this.putValue(item.getDocumentPageCountID(), pageCountValue);
        }
    }

    protected void putSectionPageCount(int sectionIndex, int pageCount) {
        FORenderer.SectionPageInformation item = this.pageNumberInformation.get(sectionIndex);
        String pageCountValue = FoNumberFormatUtil.format(pageCount, item.getSectionPageCountFoFormat());
        this.placeholderValues.put(this.createPlaceholder(item.getSectionPageCountID()), pageCountValue);
    }

    protected void putValue(String placeholderID, String value) {
        this.placeholderValues.put(this.createPlaceholder(placeholderID), value);
    }

    protected String createPlaceholder(String placeholderID) {
        return PLACEHOLDER_PREFIX + placeholderID + PLACEHOLDER_SUFFIX;
    }

    @Override
    public boolean hasPlaceholders(StringBuilder buffer) {
        return buffer.indexOf(PLACEHOLDER_PREFIX) > -1;
    }

    @Override
    public void replaceValues(StringBuilder buffer) {
        int stIdx = buffer.lastIndexOf(PLACEHOLDER_PREFIX);
        int enIdx = -1;
        String value = null;
        while (stIdx > -1) {
            enIdx = buffer.indexOf(PLACEHOLDER_SUFFIX, stIdx + PLACEHOLDER_PREFIX_LENGTH);
            if (enIdx > -1 && (value = this.placeholderValues.get(buffer.substring(stIdx, enIdx += PLACEHOLDER_SUFFIX_LENGTH))) != null) {
                buffer.replace(stIdx, enIdx, value);
            }
            stIdx = stIdx > 0 ? buffer.lastIndexOf(PLACEHOLDER_PREFIX, stIdx - 1) : -1;
        }
    }
}

