/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.util.Set;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityPlusMapper
extends Mapper {
    protected static Logger log = LoggerFactory.getLogger(IdentityPlusMapper.class);

    public IdentityPlusMapper() {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") < 0) {
            log.warn("WARNING! SubstituterWindowsPlatformImpl works best on Windows.  To get good results on other platforms, you'll probably  need to have installed Windows fonts.");
        }
    }

    @Override
    public void populateFontMappings(Set<String> documentFontNames, Fonts wmlFonts) throws Exception {
        for (String documentFontname : documentFontNames) {
            log.debug("Document font: " + documentFontname);
            PhysicalFont mappedTo = PhysicalFonts.getPhysicalFonts().get(documentFontname);
            if (mappedTo != null) {
                fontMappings.put(documentFontname, mappedTo);
                log.debug(".. mapped to " + mappedTo.getName());
                continue;
            }
            log.warn("- - No physical font for: " + documentFontname);
        }
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = "C:\\Documents and Settings\\Jason Harrop\\My Documents\\Downloads\\AUMS-easy.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        FontTablePart fontTablePart = wordMLPackage.getMainDocumentPart().getFontTablePart();
        Fonts fonts = (Fonts)fontTablePart.getJaxbElement();
        IdentityPlusMapper s = new IdentityPlusMapper();
        s.populateFontMappings(wordMLPackage.getMainDocumentPart().fontsInUse(), fonts);
    }

    static {
        try {
            PhysicalFonts.discoverPhysicalFonts();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

