/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public abstract class AbstractMessageWriter {
    public DocumentFragment notImplemented(AbstractConversionContext context, NodeIterator nodes, String message) {
        Node n = nodes.nextNode();
        context.getLog().warn("NOT IMPLEMENTED: support for " + n.getNodeName() + "; " + message);
        if (context.getLog().isDebugEnabled()) {
            if (message == null) {
                message = "";
            }
            context.getLog().debug(XmlUtils.w3CDomNodeToString(n));
            return this.message(context, "NOT IMPLEMENTED: support for " + n.getNodeName() + " - " + message);
        }
        return null;
    }

    public DocumentFragment message(AbstractConversionContext context, String message) {
        if (!context.getLog().isDebugEnabled()) {
            return null;
        }
        String documentFragment = this.getOutputPrefix() + message + this.getOutputSuffix();
        context.getLog().debug(documentFragment);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        StringReader reader = new StringReader(documentFragment);
        InputSource inputSource = new InputSource(reader);
        Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reader.close();
        DocumentFragment docfrag = doc.createDocumentFragment();
        docfrag.appendChild(doc.getDocumentElement());
        return docfrag;
    }

    protected abstract String getOutputPrefix();

    protected abstract String getOutputSuffix();
}

