/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.docs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

import javax.xml.bind.JAXBException;

import org.docx4j.XmlUtils;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.lysis.reporters.img.DrawingML;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.pptx4r.elements.Date;
import org.lysis.reporters.pptx4r.elements.Footer;
import org.lysis.reporters.pptx4r.elements.SlideNumber;
import org.lysis.reporters.pptx4r.elements.SubTitle;
import org.lysis.reporters.pptx4r.elements.Title;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.pptx4r.elements.template.MasterLayoutProperties;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.tables.XMLreader;
import org.lysis.reporters.text.CodeBlock;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.EMU;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;


public class SlideContent {
	
	public static int undefined = -1;
	public static int donotexists = 0;
	public static int isfilled = 1;
	public static int noproblem = 2;
	public static int noroomleft = 3;
	public static int undefdimension = 4;

	private SlidePart slidePart;
	private pptx4R itsPPTX;
	private long uidShape;	
	private LayoutDescription layoutDescription;
	private int slideIndex;
	private int max_shape;
	private int num_shape;
	private int freeshapeid;
	private HashMap<Integer, Boolean> headersFilled;
	private int ol_id = 1;
	private boolean lastIsParagraph = false;
	public SlideContent( SlidePart sp, pptx4R doc, LayoutDescription _layoutDescription ) throws Exception{

		this.slidePart = sp;
		itsPPTX = doc;
		uidShape = 0;
		freeshapeid = 0;
		num_shape = 0;
		layoutDescription = _layoutDescription;
		max_shape = layoutDescription.getContentSize();
		layoutDescription.fixMissingXfrm(doc.getMasterLayoutProperties());
		if( Debug.debug ) System.err.println("SlideContent - max shape " + max_shape );

		headersFilled = layoutDescription.getIsFilledHeaderModel();
	}

	public void setSlideIndex(int index){
		this.slideIndex = index;
	}
	public int getNextShapeIndex(){
		return num_shape;
	}
	
	public int getmax_shape(){
		return max_shape;
	}

	public int addTitle( String title ) {
		boolean isCRT = false;
		if( !layoutDescription.hasTitle() && layoutDescription.hasCrttitle() ) 
			isCRT=true;
		if( Debug.debug ) System.err.println("addTitle hasTitle:" + layoutDescription.hasTitle() + 
				" hasCrttitle : " + layoutDescription.hasCrttitle() );

		if( !isCRT ){
			if( !layoutDescription.hasTitle() ) return donotexists;
			else if( headersFilled.get(MasterLayoutProperties.TITLE) ) return isfilled;
			else {
				try{
					Shape sTitle = (Shape)Title.getShape(layoutDescription.getIdx_title(), uidShape+1, title);
					slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
					headersFilled.put(MasterLayoutProperties.TITLE, true);
				} catch(Exception e ) {
					return undefined;
				}
			}
		} else {
			if( headersFilled.get(MasterLayoutProperties.CRTTITLE) ) return isfilled;
			else {
				try{
					Shape sTitle = (Shape)Title.getShape(layoutDescription.getIdx_crttitle(), uidShape+1, title);
					slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
					headersFilled.put(MasterLayoutProperties.CRTTITLE, true);
				} catch(Exception e ) {
					return undefined;
				}
			}
		}
		uidShape++;
		lastIsParagraph = false;
		return noproblem;
	}

	public int addSubTitle(String title) {
		if (!layoutDescription.hasSubtitle())
			return donotexists;
		else if (headersFilled.get(MasterLayoutProperties.SUBTITLE))
			return isfilled;
		else  {
			try {
				Shape sTitle = (Shape) SubTitle.getShape( layoutDescription.getIdx_subtitle(), uidShape+1, title);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
				headersFilled.put(MasterLayoutProperties.SUBTITLE, true);
			} catch (Exception e) {
				return undefined;
			}
		}
		uidShape++;
		lastIsParagraph = false;
		return noproblem;
	}

	public int addDate( String date )  {
		if( !layoutDescription.hasDate() ) return donotexists;
		else if( headersFilled.get(MasterLayoutProperties.DATE) ) return isfilled;
		else {
			try{
				Shape sDate = (Shape)Date.getShape(layoutDescription.getIdx_date(), uidShape+1, date);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sDate);
				headersFilled.put(MasterLayoutProperties.DATE, true);
			} catch (Exception e) {
				return undefined;
			}
		}
		uidShape++;
		lastIsParagraph = false;
		return noproblem;
	}
	
	public int addSlideNumber( String slidenumber ) {
		if( !layoutDescription.hasSlideNumber() ) return donotexists;
		else if( headersFilled.get(MasterLayoutProperties.SLIDENUMBER) ) return isfilled;
		else {
			try{
				Shape sSlideNumber = (Shape)SlideNumber.getShape(layoutDescription.getIdx_slidenumber(), uidShape+1, slidenumber);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sSlideNumber);	
				headersFilled.put(MasterLayoutProperties.SLIDENUMBER, true);
			} catch (Exception e) {
				return undefined;
			}
		}
		uidShape++;
		lastIsParagraph = false;
		return noproblem;
	}
	
	public int addSlideNumber(  ) {
		return addSlideNumber(slideIndex+"");
	}
	
	public int addFooter( String footer ) {
		if( !layoutDescription.hasFooter() ) return donotexists;
		else if( headersFilled.get(MasterLayoutProperties.FOOTER) ) return isfilled;
		else {
			try{
				Shape sFooter = (Shape)Footer.getShape(layoutDescription.getIdx_footer(), uidShape+1, footer);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sFooter);
				headersFilled.put(MasterLayoutProperties.FOOTER, true);
			} catch (Exception e) {
				return undefined;
			}
		}
		uidShape++;
		lastIsParagraph = false;
		return noproblem;
	}


	
	private boolean roomLeft(){
		return (max_shape-num_shape)>0;
	}
	
	public int add( Image img,  float offx, float offy, boolean free_layout ) throws Exception {
		
		img.setPPTXMLPackage(itsPPTX.getBaseDocument());
		img.setPPTXSlidePart(slidePart);
		img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));

		if( !free_layout ){
			img.setUID(uidShape+1);
			img.setShapeID(uidShape+1);
			Pic shape = (Pic)img.get_flextable_pptx( );
			slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);

			
			uidShape = (int) img.next_id();
			num_shape++;
		} else {
			freeshapeid++;
			img.setUID(freeshapeid+uidShape);
			img.setShapeID(freeshapeid+uidShape);
			Pic shape = (Pic)img.get_flextable_pptx( );
			slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);

		}

		lastIsParagraph = false;

		return noproblem;
	}

	public int add_png( String[] files, String[] names, double[] widths, double[] heights ) throws Exception {
		
		for( int i = 0 ; i < files.length ; i++ ){
			Image img = new Image(files[i], (float)widths[i], (float)heights[i]);
			img.setPPTXMLPackage(itsPPTX.getBaseDocument());
			img.setPPTXSlidePart(slidePart);
			img.add_img_to_pptx(names[i]);
		}
		
		return noproblem;
	}
	
	public String getRelationship_xml(){
		OutputStream os ;
		os = new ByteArrayOutputStream();
		try {
			slidePart.relationships.marshal( os );
		} catch (JAXBException e) {
			e.printStackTrace();
		}
		return os.toString();
	}
	
	public int add( DrawingML d ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		d.setPPTXMLPackage(itsPPTX.getBaseDocument());
		d.setPPTXSlidePart(slidePart);
		d.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		d.setUID(uidShape+1);
		d.setShapeID(uidShape+1);

		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame()
		.addAll(d.get_flextable_pptx());
		num_shape++;
		uidShape++;
		lastIsParagraph = false;
		
		return noproblem;
	}
	
	public int add( DrawingML d, double offx, double offy, double width, double height ) throws Exception {
		
		freeshapeid++;
		
		d.setPPTXMLPackage(itsPPTX.getBaseDocument());
		d.setPPTXSlidePart(slidePart);
		d.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		d.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		d.setUID(freeshapeid+uidShape);
		d.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame()
		.addAll(d.get_flextable_pptx( ));
		lastIsParagraph = false;
		return noproblem;
	}
	
	
	public int[] getShapeDimensions(){
		int[] out = new int[4];
		out[0] = -1;out[1] = -1;out[2] = -1;out[3] = -1;
		
		if( !roomLeft() ) return out;
		else {
			CTTransform2D xfrm;
			xfrm = layoutDescription.getContent(num_shape).getXfrm();
			out[0] = (int)(xfrm.getOff().getX());
			out[1] = (int)(xfrm.getOff().getY());
			out[2] = (int)(xfrm.getExt().getCx());
			out[3] = (int)(xfrm.getExt().getCy());
		}
		return out;
	}
	
	public int add( FlexTable obj ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		obj.setTableWidth(obj.getCx());
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_flextable_pptx());
		
		num_shape++;
		uidShape++;
		lastIsParagraph = false;

		return noproblem;
	}

	public int add_xml_flextable( String str) throws Exception {
		XMLreader obj = new XMLreader(str);
		
		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_flextable_pptx());
		
		num_shape++;
		uidShape++;
		lastIsParagraph = false;

		return noproblem;
	}
	
	public int add( FlexTable obj, double offx, double offy, double width, double height ) throws Exception {
		freeshapeid++;

		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);
		obj.setTableWidth(EMU.getEMUFromInch(width));

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_flextable_pptx( ));
		lastIsParagraph = false;
		
		return noproblem;
	}
	private void incr_ol_id(ParagraphSet obj){
		if( obj.getParProperties() != null && obj.getParProperties().getListStyle().equals("ordered") && obj.getParProperties().getLevel() < 2 ){
			ol_id = ol_id + obj.size();
		}
	}
	private void init_ol_id(){
		ol_id = 1;
	}
	
	public int add( ParagraphSet obj, boolean restartNumbering) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		if( restartNumbering ) init_ol_id();
		
		Shape s =  obj.get_pptx_elt(itsPPTX.getNumberingDefinition(), ol_id);
		if( layoutDescription.getContent(num_shape).isList() && obj.getParProperties() == null )
			s.getTxBody().setLstStyle(layoutDescription.getContent(num_shape).getListStyle());
		
		
		Shape smodel = XmlUtils.deepCopy(layoutDescription.getContent(num_shape).getShape(), Context.jcPML);
		smodel.setTxBody(s.getTxBody());
		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(smodel);
		num_shape++;
		uidShape++;

		incr_ol_id(obj);
		lastIsParagraph = true;
		
		return noproblem;
	}
	
	public int add( String[] values) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		Shape smodel = XmlUtils.deepCopy(layoutDescription.getContent(num_shape).getShape(), Context.jcPML);
		java.util.Vector<CTTextParagraph> c = new java.util.Vector<CTTextParagraph>();
		
		for( int ind = 0 ; ind < values.length; ind++ ){
			CTTextParagraph tp = new CTTextParagraph();
			CTRegularTextRun regulartextrun = new CTRegularTextRun();
			regulartextrun.setT(values[ind]);
			tp.getEGTextRun().add(regulartextrun);
			c.add(tp);
		}
		smodel.getTxBody().getP().clear();
		smodel.getTxBody().getP().addAll(c);
		
		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(smodel);
		num_shape++;
		uidShape++;

		lastIsParagraph = true;
		
		return noproblem;
	}
	
	public int append( String[] values ) throws Exception {
		
		List<Object> shapes = slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();

		if( shapes.size() < 1 ){
			return add(values);
		}

		if(!lastIsParagraph){
			return isfilled;
		}

		Shape currentShape = (Shape) shapes.get(shapes.size()-1);
		for( int ind = 0 ; ind < values.length; ind++ ){
			CTTextParagraph tp = new CTTextParagraph();
			CTRegularTextRun regulartextrun = new CTRegularTextRun();
			regulartextrun.setT(values[ind]);
			tp.getEGTextRun().add(regulartextrun);
			currentShape.getTxBody().getP().add(tp);
		}

		lastIsParagraph = true;
		
		return noproblem;
	}
	
	
	public int append( ParagraphSet obj, boolean restartNumbering ) throws Exception {
		
		List<Object> shapes = slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);

		if( shapes.size() < 1 ){
			return add(obj, restartNumbering);
		}

		if(!lastIsParagraph){
			return isfilled;
		}

		if( restartNumbering ) init_ol_id();

		CTTextBody ss = obj.get_pptx_parset(itsPPTX.getNumberingDefinition(), ol_id);
		Shape currentShape = (Shape) shapes.get(shapes.size()-1);

		currentShape.getTxBody().getP().addAll(ss.getP());

		incr_ol_id(obj);
		lastIsParagraph = true;
		
		return noproblem;
	}

	public int add( ParagraphSet obj, double offx, double offy, double width, double height, 
			boolean restartNumbering ) throws Exception {
		freeshapeid++;

		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setRot(0);
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		if( restartNumbering ) init_ol_id();
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt(itsPPTX.getNumberingDefinition(), ol_id ));
		incr_ol_id(obj);
		lastIsParagraph = true;
		return noproblem;				
	}
	
	public int add( RScript obj ) throws Exception {

		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		Shape smodel = layoutDescription.getContent(num_shape).getShape();
		smodel.setTxBody(obj.get_flextable_pptx().getTxBody());

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(smodel);
		
		num_shape++;
		uidShape++;
		lastIsParagraph = true;

		return noproblem;
	}
	
	public int append( RScript obj ) throws Exception {
		List<Object> shapes = slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);

		if( shapes.size() < 1 ){
			return add(obj);
		}

		if(!lastIsParagraph){
			return isfilled;
		}

		CTTextBody ss = obj.get_pptx_parset();
		Shape currentShape = (Shape) shapes.get(shapes.size()-1);

		currentShape.getTxBody().getP().addAll(ss.getP());

		lastIsParagraph = true;
		
		return noproblem;

	}
	
	public int add( RScript obj, double offx, double offy, double width, double height ) throws Exception {		
		freeshapeid++;
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setRot(0);
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_flextable_pptx( ));
		lastIsParagraph = false;
		
		return noproblem;
	}
	
	public int add( CodeBlock obj ) throws Exception {

		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(layoutDescription.getContent(num_shape).getXfrm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		Shape smodel = layoutDescription.getContent(num_shape).getShape();
		smodel.setTxBody(obj.get_flextable_pptx().getTxBody());

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(smodel);
		
		num_shape++;
		uidShape++;
		lastIsParagraph = true;

		return noproblem;
	}
	public int append( CodeBlock obj ) throws Exception {
		List<Object> shapes = slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);

		if( shapes.size() < 1 ){
			return add(obj);
		}

		if(!lastIsParagraph){
			return isfilled;
		}

		CTTextBody ss = obj.get_pptx_parset();
		Shape currentShape = (Shape) shapes.get(shapes.size()-1);

		currentShape.getTxBody().getP().addAll(ss.getP());

		lastIsParagraph = true;
		
		return noproblem;

	}
	public int add( CodeBlock obj, double offx, double offy, double width, double height ) throws Exception {		
		freeshapeid++;
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setRot(0);
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_flextable_pptx( ));
		lastIsParagraph = false;
		
		return noproblem;
	}
	public String getLayoutName() {
		return layoutDescription.getLabel();
	}
	
}
