/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.SldLayout;

public class DocExplorer {
    public static HashMap<String, LayoutDescription> browseLayouts(PresentationMLPackage basedoc) throws InvalidFormatException {
        if (Debug.doc_explorer) {
            System.err.println("# browseLayouts");
        }
        HashMap<String, LayoutDescription> layoutDescriptionList = new HashMap<String, LayoutDescription>();
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml")) continue;
            SlideLayoutPart layoutPart = (SlideLayoutPart)basedoc.getParts().getParts().get(new PartName(((PartName)en.getKey()).getName()));
            String lpName = ((SldLayout)layoutPart.getJaxbElement()).getCSld().getName();
            String lpKey = ((PartName)en.getKey()).getName();
            if (Debug.doc_explorer) {
                System.err.println("\n\n## layout part name: " + lpName);
            }
            if (Debug.doc_explorer) {
                System.err.println("## layout part key: " + lpKey);
            }
            List slidesSet = ((SldLayout)layoutPart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
            LayoutDescription lp = new LayoutDescription(slidesSet);
            lp.setLabel(lpName);
            lp.setXMLFilename(lpKey);
            layoutDescriptionList.put(lpName, lp);
        }
        return layoutDescriptionList;
    }

    public static int countExistingSlides(PresentationMLPackage basedoc) {
        int id_slide = 0;
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) continue;
            ++id_slide;
        }
        return id_slide;
    }
}

