/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.docx4j.openpackaging.parts.relationships.Namespaces;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;

public class TOC extends DocComponent implements DOCX4R{

	private static ObjectFactory docx_factory = org.docx4j.jaxb.Context.getWmlObjectFactory();
	private P paragraph;
	private String stylename_entry;
	private String separator;
	private boolean special;
	private int entries_depth;
	
	public TOC(int entries_depth_){
		paragraph = new P();
		special = false;
		entries_depth = entries_depth_;
	}
	
	public TOC(String style, String sep ){
		paragraph = new P();
		separator = sep;
		stylename_entry = style;
		special = true;
	}

	public P get_docx_elt() {
		
		addFieldBegin(paragraph);
		if( special )
			addTableOfContentsField(paragraph, "TOC \\h \\z \\t \"" 
				+ stylename_entry + separator + "1\"");
		else {
			String inst = "TOC \\o \"1-" + entries_depth + "\" \\h \\z \\u";
			addTableOfContentsField(paragraph, inst);
		}
		
		addFieldEnd(paragraph);
		return paragraph;
	}


	private static void addTableOfContentsField(P paragraph, String expr) {
		R run = docx_factory.createR();
		Text txt = new Text();
		txt.setSpace("preserve");
		txt.setValue( expr );
		run.getContent().add(docx_factory.createRInstrText(txt));
		paragraph.getContent().add(run);
	}

	private static void addFieldBegin(P paragraph) {
		R run = docx_factory.createR();
		FldChar fldchar = docx_factory.createFldChar();
		fldchar.setFldCharType(STFldCharType.BEGIN);
		fldchar.setDirty(true);
		run.getContent().add(getWrappedFldChar(fldchar));
		paragraph.getContent().add(run);
	}

	private static void addFieldEnd(P paragraph) {
		R run = docx_factory.createR();
		FldChar fldcharend = docx_factory.createFldChar();
		fldcharend.setFldCharType(STFldCharType.END);
		run.getContent().add(getWrappedFldChar(fldcharend));
		paragraph.getContent().add(run);
	}


	public static JAXBElement<FldChar> getWrappedFldChar(FldChar fldchar) {
		return new JAXBElement<FldChar>(
				new QName(Namespaces.NS_WORD12, "fldChar"), FldChar.class, fldchar);
	}
}
