/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.math.BigInteger;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTLineProperties;
import org.docx4j.dml.CTPresetLineDashProperties;
import org.docx4j.dml.STPresetLineDashVal;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.STBorder;
import org.lysis.reporters.pptx4r.tools.Format;
import org.pptx4j.jaxb.Context;

public class BorderProperties {
    private String borderColor;
    private String borderStyle;
    private int borderWidth;

    public BorderProperties(String borderColor, String borderStyle, int borderWidth) {
        this.borderColor = borderColor;
        this.borderStyle = borderStyle;
        this.borderWidth = borderWidth;
    }

    public void print() {
        System.out.println("borderColor:" + this.borderColor + ";borderStyle:" + this.borderStyle + ";borderWidth:" + this.borderWidth + ";");
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public boolean hasBorder() {
        return !this.borderStyle.equals("none") && this.borderWidth > 0;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public CTBorder get_docx_bd() {
        CTBorder border = new CTBorder();
        if (this.borderWidth > 0 && !this.borderStyle.equals("none")) {
            border.setColor(this.borderColor);
            border.setSz(BigInteger.valueOf(this.borderWidth * 4));
            if (this.borderStyle.equals("solid")) {
                border.setVal(STBorder.SINGLE);
            } else if (this.borderStyle.equals("dotted")) {
                border.setVal(STBorder.DOTTED);
            } else if (this.borderStyle.equals("dashed")) {
                border.setVal(STBorder.DASHED);
            } else {
                border.setVal(STBorder.SINGLE);
            }
        } else {
            border.setVal(STBorder.NONE);
            border.setSz(BigInteger.valueOf(0L));
        }
        return border;
    }

    public CTLineProperties get_pptx_bd(String borderSuffix) throws Exception {
        CTLineProperties border = new CTLineProperties();
        if (this.borderWidth > 0 && !this.borderStyle.equals("none")) {
            border.setSolidFill(Format.getCol(this.borderColor));
            border.setW(Integer.valueOf(this.borderWidth * 12700));
            CTPresetLineDashProperties lineStyle = new CTPresetLineDashProperties();
            if (this.borderStyle.equals("solid")) {
                lineStyle.setVal(STPresetLineDashVal.SOLID);
            } else if (this.borderStyle.equals("dotted")) {
                lineStyle.setVal(STPresetLineDashVal.SYS_DOT);
            } else if (this.borderStyle.equals("dashed")) {
                lineStyle.setVal(STPresetLineDashVal.SYS_DASH);
            } else {
                lineStyle.setVal(STPresetLineDashVal.SOLID);
            }
            border.setPrstDash(lineStyle);
        } else {
            String borderStr = "<a:ln" + borderSuffix + " xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" w=\"12700\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:noFill /><a:prstDash val=\"solid\" /><a:round /><a:headEnd type=\"none\" w=\"med\" len=\"med\" /><a:tailEnd type=\"none\" w=\"med\" len=\"med\" /></a:ln" + borderSuffix + ">";
            border = (CTLineProperties)XmlUtils.unmarshalString((String)borderStr, (JAXBContext)Context.jcPML, CTLineProperties.class);
        }
        return border;
    }

    public String get_html_bd(String side) throws Exception {
        String out = "";
        if (this.borderWidth < 1) {
            return "";
        }
        if (this.borderStyle.equals("none")) {
            return "";
        }
        String prefix = "border-" + side + "-";
        out = out.concat(prefix);
        out = out.concat("color:");
        out = out.concat(this.borderColor);
        out = out.concat(";");
        out = out.concat(prefix);
        out = out.concat("style:");
        out = this.borderStyle.equals("solid") || this.borderStyle.equals("dotted") || this.borderStyle.equals("dashed") ? out.concat(this.borderStyle) : out.concat("solid");
        out = out.concat(";");
        out = out.concat(prefix);
        out = out.concat("width:");
        out = String.valueOf(out) + this.borderWidth;
        out = out.concat("px;");
        return out;
    }
}

