% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FlexTablePublicAPI.R
\name{spanFlexTableColumns}
\alias{spanFlexTableColumns}
\title{Span columns within rows}
\usage{
spanFlexTableColumns(object, i, from, to, runs)
}
\arguments{
\item{object}{a \code{FlexTable} object}

\item{i}{vector (integer index, row.names values or boolean vector) for rows selection.}

\item{from}{index of the first column to span (its content will be the visible one).}

\item{to}{index of the last column to span.}

\item{runs}{a vector of size \code{numcol} of FlexTable. If provided, successive
runs of equal values will indicate to merge corresponding columns.}
}
\description{
Span columns within rows.
}
\note{
Overlappings of horizontally merged cells and vertically merged cells are forbidden.
}
\examples{
#
mydata = iris[46:55, ]
MyFTable = FlexTable( data = mydata )

# merge columns 2 to 4 in line 3
MyFTable = spanFlexTableColumns( MyFTable, i = 2, from = 2, to = 4 )

# merge cells in line 4 when successive values of 
# a given character vector are identical. Note 
# the character vector length is the same 
# than the number of columns of the FlexTable.
MyFTable = spanFlexTableColumns( MyFTable, i = 4, 
  runs = c( "a", "b", "b", "c", "d") )
}
\seealso{
\code{\link{spanFlexTableRows}}, \code{\link{FlexTable}}
}

