% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGE.R
\name{BGE}
\alias{BGE}
\title{The Beta Generalized Exponentiated family}
\usage{
BGE(mu.link = "log", sigma.link = "log", nu.link = "log", tau.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}

\item{tau.link}{defines the tau.link, with "log" link as the default for the tau parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a BGE distribution in the \code{gamlss()} function.
}
\description{
The Beta Generalized Exponentiated family
}
\details{
The Beta Generalized Exponentiated distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x)= \frac{\nu \tau}{B(\mu, \sigma)} \exp(-\nu x)(1- \exp(-\nu x))^{\tau \mu - 1} (1 - (1- \exp(-\nu x))^\tau)^{\sigma -1},}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0}, \eqn{\nu > 0} and \eqn{\tau > 0}.
}
\examples{
# Generating some random values with
# known mu, sigma, nu and tau
y <- rBGE(n=100, mu = 1.5, sigma =1.7, nu=1, tau=1)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, tau.fo=~1, family=BGE,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma, nu and tau
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))
exp(coef(mod, what='tau'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.4, max=0.6)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(0.5 - x1)
sigma <- exp(0.8 - x2)
nu <- 1
tau <- 1
x <- rBGE(n=n, mu, sigma, nu, tau)

mod <- gamlss(x~x1, sigma.fo=~x2, nu.fo=~1, tau.fo=~1, family=BGE,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
exp(coef(mod, what="tau"))
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{barreto2010beta}{RelDists}
}
\seealso{
\link{dBGE}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
