% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxLGlasso.R
\name{maxLGlasso}
\alias{maxLGlasso}
\title{An algorithm for determining the smallest values for Lasso and Group Lasso tuning parameters that yield all zeros.}
\usage{
maxLGlasso(DATA, Jk, R)
}
\arguments{
\item{DATA}{The concatenated data block, with rows representing subjects.}

\item{Jk}{A vector. Each element of this vector is the number of columns of a data block.}

\item{R}{The number of components.}
}
\value{
\item{Glasso}{The maximum value for Group Lasso tuning parameter.}
\item{Lasso}{The maximum value for Lasso tuning parameter.}
}
\description{
\code{maxLGlasso} identify the minimum value for Lasso and Group Lasso tuning parameters that
lead to an estimated P matrix with all of its elements equal 0. This minimum value is thus the maximum value (the boundary) that users
should consider for Lasso and Group Lasso.
}
\note{
The description of how to obtain the maximum value for Lasso tuning parameter can be found in page 17 of Hastie, Tibshirani, and Wainwright (2015). We are not aware of 
any literature that mentions how to obtain the maximum value for Group Lasso, but this value can easily be derived from the algorithm.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5)
DATA <- cbind(DATA1, DATA2)
Jk <- c(10, 20) 
results <- maxLGlasso(DATA, Jk, R=5)
maxGLasso <- results$Glasso
maxLasso <- results$Lasso
}
}
\references{
Hastie, T., Tibshirani, R., & Wainwright, M. (2015). \emph{Statistical learning with sparsity}. CRC press.
}
