% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ratio.R
\name{compute_ratio}
\alias{compute_ratio}
\title{Function to compute the main statistic for the point estimate}
\usage{
compute_ratio(
  x_eps0,
  Xp,
  Yp,
  for_critY,
  dimXnc,
  weights_xp,
  weights_yp,
  version = "first",
  grid_I = NULL,
  ties = FALSE
)
}
\arguments{
\item{x_eps0}{a matrix containing the directions to compute the radial function, and the associated choice epsilon(q).}

\item{Xp}{the observations of the noncommon regressor (possibly conditional on Xc).}

\item{Yp}{the observations of the outcome variable.}

\item{for_critY}{the numerator of the ratio R for the point estimate of the radial function, on the grid grid_I;}

\item{dimXnc}{the dimension of the noncommon regressors}

\item{weights_xp}{the sampling or bootstrap weights for the dataset (Xnc,Xc).}

\item{weights_yp}{the sampling or bootstrap weights for the dataset (Y,Xc).}

\item{version}{version of the computation of the ratio, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{grid_I}{the grid of alpha on which we evaluate the ratio R to compute the point estimate of the radial function.}

\item{ties}{binary value handling the ties, default is FALSE.}
}
\value{
the value of the point estimate of the radial function using the DGM method.
}
\description{
Function to compute the main statistic for the point estimate
}
