% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RedditExtractoR.R
\name{reddit_urls}
\alias{reddit_urls}
\title{Returns relevant reddit URLs}
\usage{
reddit_urls(search_terms = NA, regex_filter = "", subreddit = NA,
  cn_threshold = 0, page_threshold = 1, sort_by = "comments",
  wait_time = 2)
}
\arguments{
\item{search_terms}{A string of terms to be searched on Reddit.}

\item{regex_filter}{An optional regular expression filter that will remove URLs with titles that do not match the condition.}

\item{subreddit}{An optional character string that will restrict the search to the specified subreddit.}

\item{cn_threshold}{Comment number threshold that remove URLs with fewer comments that cn_threshold. 0 by default.}

\item{page_threshold}{Page threshold that controls the number of pages is going to be searched for a given search word. 1 by default.}

\item{sort_by}{Sorting parameter, either "comments" (default) or "new".}

\item{wait_time}{wait time in seconds between page requests. 2 by default and it is also the minimum (API rate limit).}
}
\value{
A data frame with URLs (links), number of comments (num_comments), title (title),date (date) and subreddit (subreddit).
}
\description{
Returns relevant reddit URLs
}
\examples{
example_urls = reddit_urls(search_terms="science")
}

