% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_record.R
\name{series_record}
\alias{series_record}
\title{From Record Times to Time Series}
\usage{
series_record(L_upper, R_upper, L_lower, R_lower, Trows = NA)
}
\arguments{
\item{L_upper, L_lower}{A vector of (increasing) integers denoting the upper 
or/and lower record times.}

\item{R_upper, R_lower}{(Optional) A vector of (increasing/decreasing)
values denoting the upper or/and lower record values.}

\item{Trows}{Integer indicating the actual length of the series. If it is 
not specified, then the length of the series is assumed equal to the last
record occurrence.}
}
\value{
A vector of length \code{Trows} with \code{L_upper} upper or/and 
  \code{L_lower} lower record times and \code{R_upper} upper or/and 
  \code{R_lower} lower record values.
}
\description{
This function is useful to apply the plots and tests within
  \code{\link{RecordTest-package}} to a vector of record times. If only the
  record times are available (upper or lower, or both) and not the complete 
  series, \code{series_record} builds a complete series with the same record 
  occurrence as specified in the arguments.
}
\note{
Remember 1 is always a record time.
}
\examples{
# upper record times observed in a 100 length time series
L <- c(1, 4, 14, 40, 45, 90)
X <- series_record(L_upper = L, Trows = 100)

# now you can apply plots and tests for upper records to the X series
#N.plot(X)
#N_normal.test(X)

# if you also have lower record times
L_lower <- c(1, 2, 12, 56, 57, 78, 91)
X <- series_record(L_upper = L, L_lower = L_lower, Trows = 100)

# now you can apply plots and tests to the X series with both types of record times
#foster.plot(X, statistic = 'd')
#foster.test(X, statistic = 'd')

# apply to the 200-meter Olympic records from 1900 to 2020
or200m <- series_record(L_lower = Olympic_records_200m$t, 
                        R_lower = Olympic_records_200m$value,
                        Trows = 27)
# some plots and tests                    
N.plot(or200m, record = c(0,1,0,0))                         
N.test(or200m, record = "lower", distribution = "poisson-binomial")
}
\seealso{
\code{\link{series_double}}, \code{\link{series_rev}}, 
  \code{\link{series_split}}, \code{\link{series_ties}},
  \code{\link{series_uncor}}, \code{\link{series_untie}}
}
\author{
Jorge Castillo-Mateo
}
