% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DaySeries.fun.R
\name{DaySeries.fun}
\alias{DaySeries.fun}
\title{Transforms a daily values vector  into  a matrix}
\usage{
DaySeries.fun(vect, ncols = 365)
}
\arguments{
\item{vect}{A  numeric vector.}

\item{ncols}{An integer number, giving  the number of columns in the  final matrix.}
}
\value{
A matrix.
}
\description{
This function rearranges a vector of consecutive  daily values
into a matrix format, where each column is the vector of values at the same  day of the year.
}
\details{
This function is used in the data preparation  (or pre-processing) often
required to apply the record inference tools in this package.

 This function transforms a daily values vector  into  a matrix, applying the following procedure: the first row  of the matrix is made up of
the first \code{ncols} elements of the vector, the second row by the \code{ncols} following elements, and so on.
The length of the vector must be  a multiple of  \code{ncols}.

In the case of  a vector of daily values, \code{ncols} is usually 365,
so that the first column corresponds  to  all the values observed at the  first of January, the second to the second of January, etc,
}
\examples{
DaySeries.fun(1:100, ncols = 10)

}
\seealso{
\code{\link{double.fun}}, \code{\link{mintime.cor.test}}
}
