% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remfpcaClass.R
\name{remfpca}
\alias{remfpca}
\alias{Remfpca}
\title{A Class for `ReMFPCA` objects}
\usage{
Remfpca(
  mvmfd_obj,
  ncomp,
  alpha = NULL,
  centerfns = TRUE,
  alpha_orth = TRUE,
  penalty_type = "coefpen"
)
}
\arguments{
\item{mvmfd_obj}{An `mvmfd` object representing the multivariate functional data.}

\item{ncomp}{The number of functional principal components to retain.}

\item{alpha}{A list or vector specifying the regularization parameter(s) for each variable.
If NULL, the regularization parameter is estimated internally.}

\item{centerfns}{Logical indicating whether to center the functional data before analysis.}

\item{alpha_orth}{Logical indicating whether to perform orthogonalization of the regularization parameters.}

\item{penalty_type}{The type of penalty to be applied on the coefficients. The types "coefpen" and "basispen" is supported. Default is "coefpen".}
}
\description{
The `remfpca` class represents regularized functional principal components components.

The `remfpca` class represents regularized functional principal components ('ReMFPCs') components.
}
\examples{
require(fda)
# Brownian Bridge simulation on [0,1]
M <- 110 # number of components
N <- 20 # number of instances
n <- 100 # number of grides
t0 <- seq(0, 1, len = n)
j <- 1:M
alpha1 <- list(a1 = 2^seq(0, 1, length.out = 3), a2 = 2^seq(0, 1, length.out = 3))
psi_1 <- function(t, m) sin(m * pi * t) # eigenfunction of BB
psi_2 <- function(t, m) sin((2 * m - 1) * pi / 2 * t) # eigenfunction of BM
PC_1 <- outer(t0, j, FUN = psi_1) # n by M matrix
PC_2 <- outer(t0, j, FUN = psi_2) # n by M matrix
Z <- matrix(rnorm(N * M), nr = M)
lambda <- matrix(2 / (pi * (2 * j - 1)), nr = M, nc = N)
X_1t <- PC_1 \%*\% (lambda * Z)
X_2t <- PC_2 \%*\% (lambda * Z)
noise <- rnorm(n * N, 0, 0.1)
X_1 <- X_1t + noise
X_2 <- X_2t + noise
bs <- create.bspline.basis(c(0, 1), 51)
mdbs <- Basismfd(bs)
mfd1 <- Mfd(X = X_1, mdbs = mdbs)
mfd2 <- Mfd(X = X_2, mdbs = mdbs)
mvmfd_obj <- Mvmfd(mfd1, mfd2)
k <- 2
Re0 <- Remfpca(mvmfd_obj, ncomp = k, alpha = c(0, 0))
fpc0 <- Re0$pc_mfd
scores0 <- inprod_mvmfd(mvmfd_obj, fpc0)
dim(scores0)
Re0$alpha
Re1 <- Remfpca(mvmfd_obj, ncomp = k, alpha = alpha1)
Re1$alpha
Re3 <- Remfpca(mfd1, ncomp = k, alpha = alpha1$a1)
Re3$alpha
}
\seealso{
\code{\link{mvmfd}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pc_mfd}}{an object of class `mvmfd` where the first indices (fields)
represents harmonics and  second indices represents variables}

\item{\code{lsv}}{= Left singular values vectors}

\item{\code{values}}{= the set of eigenvalues}

\item{\code{alpha}}{= The vector of penalties parameters}

\item{\code{GCVs}}{= generalized cross validations}

\item{\code{mean_mfd}}{a multivariate functional data object giving the mean function}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-remfpca-new}{\code{remfpca$new()}}
\item \href{#method-remfpca-clone}{\code{remfpca$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remfpca-new"></a>}}
\if{latex}{\out{\hypertarget{method-remfpca-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{remfpca$new(
  mvmfd_obj,
  ncomp,
  alpha = NULL,
  centerfns = TRUE,
  alpha_orth = TRUE,
  penalty_type = "coefpen"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mvmfd_obj}}{An `mvmfd` object representing the multivariate functional data.}

\item{\code{ncomp}}{The number of functional principal components to retain.}

\item{\code{alpha}}{A list or vector specifying the regularization parameter(s) for each variable.
If NULL, the regularization parameter is estimated internally.}

\item{\code{centerfns}}{Logical indicating whether to center the functional data before analysis.}

\item{\code{alpha_orth}}{Logical indicating whether to perform orthogonalization of the regularization parameters.}

\item{\code{penalty_type}}{The type of penalty to be applied on the coefficients. The types "coefpen" and "basispen" is supported. Default is "coefpen".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remfpca-clone"></a>}}
\if{latex}{\out{\hypertarget{method-remfpca-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{remfpca$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
