/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import org.drools.compiler.Dialect;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.mvel.MVELDialect;

public class MVELDialectConfiguration
implements DialectConfiguration {
    private PackageBuilderConfiguration conf;
    private boolean strict;
    private int langLevel;

    public Dialect newDialect(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        return new MVELDialect(packageBuilder, pkgRegistry, pkg);
    }

    public void init(PackageBuilderConfiguration conf) {
        this.conf = conf;
        this.setStrict(this.determineStrict());
        this.setLangLevel(this.determineLangLevel());
    }

    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.conf;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setLangLevel(int langLevel) {
        this.langLevel = langLevel;
    }

    public int getLangLevel() {
        return this.langLevel;
    }

    private boolean determineStrict() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.strict", "true");
        return Boolean.valueOf(prop);
    }

    private int determineLangLevel() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.langLevel", "4");
        return Integer.valueOf(prop);
    }
}

