% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.abund.R
\name{summary.abund}
\alias{summary.abund}
\title{Summarize abundance estimates}
\usage{
\method{summary}{abund}(
  object,
  criterion = "AICc",
  maxBSFailPropForWarning = RdistanceControls()$maxBSFailPropForWarning,
  ...
)
}
\arguments{
\item{object}{An object output by \code{abundEstim}.  This is a distance 
function object augmented with abundance estimates, and has 
class \code{c("abund", "dfunc")}.}

\item{criterion}{A string specifying the criterion to print.
Must be one of "AICc" (the default), 
"AIC", or "BIC".  See \code{\link{AIC.dfunc}} for formulas.}

\item{maxBSFailPropForWarning}{The proportion of bootstrap 
iterations that can fail without a warning. If the proportion 
of bootstrap iterations that did not converge exceeds this 
parameter, a warning about the validity of CI's is issued and 
a diagnostic message printed.  Increasing this to a number greater 
than 1 will kill the warning, but ignoring a large number of non-convergent
bootstrap iterations may be a bad idea (i.e., validity of the CI is 
questionable).}

\item{\dots}{Included for compatibility to other print methods.
Ignored here.}
}
\value{
0 is invisibly returned.
}
\description{
Summarize an object of class \code{c("abund","dfunc")} 
that is output by \code{abundEstim}.
}
\details{
The default summary method for class 'dfunc' is 
called first, then the abundance estimates are printed.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)
data(sparrowSiteData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist ~ 1 + offset(groupsize)
                  , detectionData=sparrowDetectionData)

# Estimate abundance given the detection function
# Note: do more than R=20 bootstrap iterations
fit <- abundEstim(dfunc
                , detectionData = sparrowDetectionData
                , siteData = sparrowSiteData
                , area = units::set_units(4105, "km^2")
                , R=20
                , ci=0.95)

summary(fit)

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}, 
\code{\link{summary.dfunc}}, \code{\link{print.dfunc}}, 
\code{\link{print.abund}}
}
\keyword{models}
