% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_linear_SPCA.R
\name{do.spca}
\alias{do.spca}
\title{Sparse Principal Component Analysis}
\usage{
do.spca(X, ndim = 2, mu = 1, rho = 1, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{mu}{an augmented Lagrangian parameter.}

\item{rho}{a regularization parameter for sparsity.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{abstol}{absolute tolerance stopping criterion (default: 1e-8).}
\item{reltol}{relative tolerance stopping criterion (default: 1e-4).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Sparse PCA (\code{do.spca}) is a variant of PCA in that each loading - or, principal
component - should be sparse. Instead of using generic optimization package,
we opt for formulating a problem as semidefinite relaxation and utilizing ADMM.
}
\examples{
\donttest{
## use iris data
data(iris, package="Rdimtools")
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## try different regularization parameters for sparsity
out1 <- do.spca(X,ndim=2,rho=0.01)
out2 <- do.spca(X,ndim=2,rho=1)
out3 <- do.spca(X,ndim=2,rho=100)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=lab, pch=19, main="SPCA::rho=0.01")
plot(out2$Y, col=lab, pch=19, main="SPCA::rho=1")
plot(out3$Y, col=lab, pch=19, main="SPCA::rho=100")
par(opar)
}

}
\references{
\insertRef{zou_sparse_2006}{Rdimtools}

\insertRef{daspremont_direct_2007}{Rdimtools}

\insertRef{ma_alternating_2013}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
\concept{linear_methods}
