% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NPE.R
\name{do.npe}
\alias{do.npe}
\title{Neighborhood Preserving Embedding}
\usage{
do.npe(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = "union",
  weight = TRUE,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  regtype = FALSE,
  regparam = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform NPE on weighted graph, or \code{FALSE} otherwise.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{regtype}{\code{FALSE} for not applying automatic Tikhonov Regularization,
or \code{TRUE} otherwise.}

\item{regparam}{a positive real number for Regularization. Default value is 1.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{eigval}{a vector of eigenvalues corresponding to basis expansion in an ascending order.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.npe} performs a linear dimensionality reduction using Neighborhood Preserving
Embedding (NPE) proposed by He et al (2005). It can be regarded as a linear approximation
to Locally Linear Embedding (LLE). Like LLE, it is possible for the weight matrix being rank deficient.
If \code{regtype} is set to \code{TRUE} with a proper value of \code{regparam}, it will
perform Tikhonov regularization as designated. When regularization is needed
with \code{regtype} parameter to be \code{FALSE}, it will automatically find a suitable
regularization parameter and put penalty for stable computation. See also
\code{\link{do.lle}} for more details.
}
\examples{
\dontrun{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## use different settings for connectivity
output1 = do.npe(X, ndim=2, type=c("proportion",0.10))
output2 = do.npe(X, ndim=2, type=c("proportion",0.25))
output3 = do.npe(X, ndim=2, type=c("proportion",0.50))

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, pch=19, col=label, main="NPE::10\% connected")
plot(output2$Y, pch=19, col=label, main="NPE::25\% connected")
plot(output3$Y, pch=19, col=label, main="NPE::50\% connected")
par(opar)
}

}
\references{
\insertRef{he_neighborhood_2005}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
