% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_nonlinear_HYDRA.R
\name{do.hydra}
\alias{do.hydra}
\title{Hyperbolic Distance Recovery and Approximation}
\usage{
do.hydra(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{...}{extra parameters including \describe{
\item{kappa}{embedding curvature, which is a nonnegative number (default: 1).}
\item{iso.adjust}{perform isotropic adjustment. If \code{ndim=2}, default is \code{FALSE}. Otherwise, \code{TRUE} is used as default.}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations in the Poincare disk.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Hyperbolic Distance Recovery and Approximation, also known as \code{hydra} in short,
implements embedding of distance-based data into hyperbolic space represented as the Poincare disk,
which is interior of a hypersphere.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## multiple runs with varying curvatures
embed1 <- do.hydra(X, kappa=0.1)
embed2 <- do.hydra(X, kappa=1)
embed3 <- do.hydra(X, kappa=10)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(embed1$Y , col=lab, pch=19, main="kappa=0.1")
plot(embed2$Y , col=lab, pch=19, main="kappa=1")
plot(embed3$Y , col=lab, pch=19, main="kappa=10")
par(opar)
}

}
\references{
\insertRef{keller-ressel_2020_HydraMethodStrainminimizing}{Rdimtools}
}
\concept{nonlinear_methods}
