% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KLDE.R
\name{do.klde}
\alias{do.klde}
\title{Kernel Local Discriminant Embedding}
\usage{
do.klde(
  X,
  label,
  ndim = 2,
  t = 1,
  numk = max(ceiling(nrow(X)/10), 2),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  ktype = c("gaussian", 1),
  kcentering = TRUE
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{t}{kernel bandwidth in \eqn{(0,\infty)}.}

\item{numk}{the number of neighboring points for k-nn graph construction.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{ktype}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}

\item{kcentering}{a logical; \code{TRUE} to use centered Kernel matrix, \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Kernel Local Discriminant Embedding (KLDE) is a variant of Local Discriminant Embedding in that
it aims to preserve inter- and intra-class neighborhood information in a nonlinear manner using
kernel trick. \emph{Note} that the combination of kernel matrix and its eigendecomposition
often suffers from lacking numerical rank. For such case, our algorithm returns a warning message and
algorithm stops working any further due to its innate limitations of constructing weight matrix.
}
\examples{
\donttest{
## generate data of 2 types with clear difference
set.seed(100)
diff = 25
dt1  = aux.gensamples(n=50)-diff;
dt2  = aux.gensamples(n=50)+diff;

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2)
label  = rep(1:2, each=50)

## try different neighborhood size
out1 <- do.klde(X, label, numk=5)
out2 <- do.klde(X, label, numk=10)
out3 <- do.klde(X, label, numk=20)

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, pch=19, main="k=5")
plot(out2$Y, col=label, pch=19, main="k=10")
plot(out3$Y, col=label, pch=19, main="k=20")
par(opar)
}

}
\references{
\insertRef{hwann-tzongchen_local_2005}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
