% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_made.R
\name{est.made}
\alias{est.made}
\title{Manifold-Adaptive Dimension Estimation}
\usage{
est.made(
  X,
  k = round(sqrt(ncol(X))),
  maxdim = min(ncol(X), 15),
  combine = c("mean", "median", "vote")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k}{size of neighborhood for analysis.}

\item{maxdim}{maximum possible dimension allowed for the algorithm to investigate.}

\item{combine}{method to aggregate local estimates for a single global estimate.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated global intrinsic dimension.}
\item{estloc}{a length-\eqn{n} vector estimated dimension at each point.}
}
}
\description{
\code{do.made} first aims at finding local dimesion estimates using nearest neighbor techniques based on
the first-order approximation of the probability mass function and then combines them to get a single global estimate. Due to the rate of convergence of such
estimate to be independent of assumed dimensionality, authors claim this method to be
\emph{manifold-adaptive}.
}
\examples{
\donttest{
## create a data set of intrinsic dimension 2.
X = aux.gensamples(dname="swiss")

## compare effect of 3 combining scheme
out1 = est.made(X, combine="mean")
out2 = est.made(X, combine="median")
out3 = est.made(X, combine="vote")

## print the results
sprintf("* est.made : estimated dimension with 'mean'   method is \%d.",out1$estdim)
sprintf("* est.made : estimated dimension with 'median' method is \%d.",out2$estdim)
sprintf("* est.made : estimated dimension with 'vote'   method is \%d.",out3$estdim)
}

}
\references{
\insertRef{farahmand_manifoldadaptive_2007}{Rdimtools}
}
\author{
Kisung You
}
