% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{relatedConcepts}
\alias{relatedConcepts}
\title{Obtain related concepts for a set of SNOMED CT concepts}
\usage{
relatedConcepts(
  conceptIds,
  typeId = bit64::as.integer64("116680003"),
  tables = c("RELATIONSHIP", "STATEDRELATIONSHIP"),
  reverse = FALSE,
  recursive = FALSE,
  active_only = TRUE,
  SNOMED = getSNOMED()
)
}
\arguments{
\item{conceptIds}{character or integer64 vector}

\item{typeId}{concept ID of relationship type.
Defaults to 116680003 = Is a}

\item{tables}{vector of names of relationship table(s) to use;
by default use both RELATIONSHIP and STATEDRELATIONSHIP}

\item{reverse}{whether to reverse the relationship}

\item{recursive}{whether to re-apply the function on the outputs}

\item{active_only}{whether to limit the output to active concepts only}

\item{SNOMED}{environment containing a SNOMED dictionary}
}
\value{
a data.table with the following columns: id, conceptId, type
  (only if include_synonyms = TRUE), term,
  active (only if active_only = FALSE)
}
\description{
Returns concepts with a particular relation to a supplied set of
SNOMED CT concepts
}
\examples{
# Load sample SNOMED CT dictionary
SNOMED <- sampleSNOMED()

# Example: anatomical site of a finding
findingSite <- function(x){
  relatedConcepts(as.SNOMEDconcept(x),
    typeId = as.SNOMEDconcept('Finding site'))
}

description(findingSite('Heart failure'))
# Heart structure (body structure)
}
