% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_refman.R
\name{render_refman}
\alias{render_refman}
\title{Create Markdown Reference Manual}
\usage{
render_refman(pkg = getwd(), output_file = NULL, output_format = md_document())
}
\arguments{
\item{pkg}{Full path to package directory.
Default value is the current working directory.
Alternatively, a package name can be passed as string.
If this is the case, \code{\link[base:find.package]{base::find.package()}} is applied.}

\item{output_file}{Specify outputfile, including file extension}

\item{output_format}{Output format function. See \code{\link[=output_format]{output_format()}}.
Default is \code{\link[=md_document]{md_document()}}, but one could provide a custom output format.}
}
\description{
This is a wrapper to combine the Rd files
of a package source or binary into a reference manual in markdown format.
}
\examples{
## give source directory of your package
pkg_dir = "~/git/MyPackage"

## create reference manual
## render_refman(pkg_dir)
}
\references{
Murdoch, D. (2010).
\href{https://developer.R-project.org/parseRd.pdf}{Parsing Rd files}
}
\seealso{
\itemize{
\item Package \href{https://github.com/jbryer/Rd2markdown}{Rd2markdown},
on which the original version was based on.
\item Package \href{https://github.com/r-lib/pkgdown}{pkgdown},
on which the current (refactored) version is based on.
}
}
