# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

example0 <- function() {
    invisible(.Call('RcppCCTZ_example0', PACKAGE = 'RcppCCTZ'))
}

helloMoon <- function(verbose = FALSE) {
    .Call('RcppCCTZ_helloMoon', PACKAGE = 'RcppCCTZ', verbose)
}

example1 <- function() {
    invisible(.Call('RcppCCTZ_example1', PACKAGE = 'RcppCCTZ'))
}

example2 <- function() {
    .Call('RcppCCTZ_example2', PACKAGE = 'RcppCCTZ')
}

example3 <- function() {
    invisible(.Call('RcppCCTZ_example3', PACKAGE = 'RcppCCTZ'))
}

example4 <- function() {
    invisible(.Call('RcppCCTZ_example4', PACKAGE = 'RcppCCTZ'))
}

exampleFormat <- function() {
    invisible(.Call('RcppCCTZ_exampleFormat', PACKAGE = 'RcppCCTZ'))
}

#' Difference between two given timezones at a specified date.
#'
#' Time zone offsets vary by date, and this helper function computes
#' the difference (in hours) between two time zones for a given date time.
#'
#' @title Return difference between two time zones at a given date.
#' @param tzfrom The first time zone as a character vector.
#' @param tzto The second time zone as a character vector.
#' @param dt A Datetime object specifying when the difference is to be computed.
#' @param verbose A boolean toggle indicating whether more verbose operations
#' are desired, default is \code{FALSE}.
#' @return A numeric value with the difference (in hours) between the first and
#' second time zone at the given date
#' @author Dirk Eddelbuettel
#' @examples
#' # simple call: difference now
#' tzDiff("America/New_York", "Europe/London", Sys.time())
#' # tabulate difference for every week of the year
#' table(sapply(0:52, function(d) tzDiff("America/New_York", "Europe/London",
#'                                       as.POSIXct(as.Date("2016-01-01") + d*7))))
tzDiff <- function(tzfrom, tzto, dt, verbose = FALSE) {
    .Call('RcppCCTZ_tzDiff', PACKAGE = 'RcppCCTZ', tzfrom, tzto, dt, verbose)
}

#' Change from one given timezone to another.
#'
#' Time zone offsets vary by date, and this helper function converts
#' a Datetime object from one given timezone to another.
#'
#' @title Shift datetime object from one timezone to another
#' @param dt A Datetime object specifying when the difference is to be computed.
#' @param tzfrom The first time zone as a character vector.
#' @param tzto The second time zone as a character vector.
#' @param verbose A boolean toggle indicating whether more verbose operations
#' are desired, default is \code{FALSE}.
#' @return A Datetime object with the given (civil time) determined by the
#' incoming object (and its timezone) shifted to the target timezone.
#' @author Dirk Eddelbuettel
#' @examples
#' toTz(Sys.time(), "America/New_York", "Europe/London")
#' # this redoes the 'Armstrong on the moon in NYC and Sydney' example
#' # note that the default print method will print the return object in _your local time_
#' toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), "America/New_York", "Australia/Sydney", verbose=TRUE)
#' # whereas explicitly formating for Sydney time does the right thing
#' format(toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), 
#'             "America/New_York", "Australia/Sydney", verbose=TRUE), 
#'        tz="Australia/Sydney")
toTz <- function(dt, tzfrom, tzto, verbose = FALSE) {
    .Call('RcppCCTZ_toTz', PACKAGE = 'RcppCCTZ', dt, tzfrom, tzto, verbose)
}

#' Format a Datetime vector
#'
#' An alternative to \code{format.POSIXct} based on the CCTZ library. The
#' \code{formatDouble} variant uses two vectors for seconds since the epoch 
#' and fractional nanoseconds, respectively, to provide fuller resolution.
#'
#' @title Format a Datetime vector as a string vector
#' @param dtv A Datetime vector object to be formatted
#' @param fmt A string with the format, which is based on \code{strftime} with some
#'   extensions; see the CCTZ documentation for details.
#' @param lcltzstr The local timezone object for creation the CCTZ timepoint
#' @param tgttzstr The target timezone for the desired format
#' @return A string vector with the requested format of the datetime objects
#' @section Note:
#' Windows is now supported via the \code{g++-4.9} compiler, but note
#' that it provides an \emph{incomplete} C++11 library. This means we had
#' to port a time parsing routine, and that string formatting is more
#' limited. As one example, CCTZ frequently uses \code{"\%F \%T"} which do
#' not work on Windows; one has to use \code{"\%Y-\%m-\%d \%H:\%M:\%S"}.
#' @author Dirk Eddelbuettel
#' @examples
#' now <- Sys.time()
#' formatDatetime(now)            # current (UTC) time, in full precision RFC3339
#' formatDatetime(now, tgttzstr="America/New_York")  # same but in NY
#' formatDatetime(now + 0:4)	   # vectorised
formatDatetime <- function(dtv, fmt = "%Y-%m-%dT%H:%M:%E*S%Ez", lcltzstr = "UTC", tgttzstr = "UTC") {
    .Call('RcppCCTZ_formatDatetime', PACKAGE = 'RcppCCTZ', dtv, fmt, lcltzstr, tgttzstr)
}

#' Parse a Datetime vector
#'
#' An alternative to \code{as.POSIXct} based on the CCTZ library
#'
#' @title Parse a Datetime vector from a string vector
#' @param svec A string vector from which a Datetime vector is to be parsed
#' @param fmt A string with the format, which is based on \code{strftime} with some
#'   extensions; see the CCTZ documentation for details.
#' @param tzstr The local timezone for the desired format
#' @return A Datetime vector object for \code{parseDatetime}, a numeric matrix with
#' two columns for seconds and nanoseconds for \code{parseDouble}
#' @author Dirk Eddelbuettel
#' @examples
#' ds <- getOption("digits.secs")
#' options(digits.secs=6) # max value
#' parseDatetime("2016-12-07 10:11:12",        "%Y-%m-%d %H:%M:%S");   # full seconds
#' parseDatetime("2016-12-07 10:11:12.123456", "%Y-%m-%d %H:%M:%E*S"); # fractional seconds
#' parseDatetime("2016-12-07T10:11:12.123456-00:00")  ## default RFC3339 format
#' now <- trunc(Sys.time())
#' parseDatetime(formatDatetime(now + 0:4))	   			# vectorised
#' options(digits.secs=ds)
parseDatetime <- function(svec, fmt = "%Y-%m-%dT%H:%M:%E*S%Ez", tzstr = "UTC") {
    .Call('RcppCCTZ_parseDatetime', PACKAGE = 'RcppCCTZ', svec, fmt, tzstr)
}

#' @rdname formatDatetime
#' @param secv A numeric vector with seconds since the epoch
#' @param nanov A numeric vector with nanoseconds since the epoch,
#' complementing \code{secv}.
formatDouble <- function(secv, nanov, fmt = "%Y-%m-%dT%H:%M:%E*S%Ez", tgttzstr = "UTC") {
    .Call('RcppCCTZ_formatDouble', PACKAGE = 'RcppCCTZ', secv, nanov, fmt, tgttzstr)
}

#' @rdname parseDatetime
parseDouble <- function(svec, fmt = "%Y-%m-%dT%H:%M:%E*S%Ez", tzstr = "UTC") {
    .Call('RcppCCTZ_parseDouble', PACKAGE = 'RcppCCTZ', svec, fmt, tzstr)
}

now <- function() {
    invisible(.Call('RcppCCTZ_now', PACKAGE = 'RcppCCTZ'))
}

