% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{saveClustering}
\alias{saveClustering}
\title{Clustering saving}
\usage{
saveClustering(filename.csv, label, dir)
}
\arguments{
\item{filename.csv}{character vector specifying the path and the name of the csv file.}

\item{label}{vector of labels.}

\item{dir}{character vector specifying the directory where to save the csv file.}
}
\value{
csv file containing clustering result.
}
\description{
Save a clustering result in a csv file.
}
\details{
saveClustering saves a clustering result in a csv file
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1, dir.save=tempdir())
res <- KmeansQuick(x$features$initial$x, K=3)

tf2 <- tempfile()
saveClustering(basename(tf2), res$cluster, tempdir())


}
\seealso{
\code{\link{loadClusteringSample}}
}
