% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{updateClustersNames}
\alias{updateClustersNames}
\title{Clusters names updating}
\usage{
updateClustersNames(data.sample, protos)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{protos}{list of selected prototypes (with index and name).}
}
\value{
data.sample list containing features, profiles and clustering results with updated labels names.
}
\description{
Update the clusters names according to the names assigning to each prototype.
}
\details{
updateClustersNames updates the clusters names according to the names assigning to each prototype
}
\examples{
\donttest{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)

new.protos <- visualizeSampleClustering(x, selection.mode = "prototypes", 
			 profile.mode="none", wait.close=FALSE)
x <- updateClustersNames(x, new.protos$prototypes)

}
}
\keyword{internal}
