% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetprob.R
\name{effect.hetprob}
\alias{effect.hetprob}
\alias{summary.effect.hetprob}
\alias{print.summary.effect.hetprob}
\title{Get average marginal effects for heterokedastic binary models}
\usage{
effect.hetprob(
  object,
  vcov = NULL,
  digits = max(3, getOption("digits") - 2),
  ...
)

\method{summary}{effect.hetprob}(object, ...)

\method{print}{summary.effect.hetprob}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \code{hetprob} and \code{effect.hetprob} for \code{summary} and \code{print} method.}

\item{vcov}{an estimate of the asymptotic variance-covariance matrix of the parameters for a \code{hetprob} object.}

\item{digits}{the number of digits.}

\item{...}{further arguments.Ignored.}

\item{x}{an object of class \code{effect.hetprob}.}
}
\value{
An object of class \code{effect.heprob}.
}
\description{
Obtain the average marginal effects from \code{hetprob} class model.
}
\details{
This function allows to obtain the average marginal effects (not the marginal effects at the mean). The standard errors are computed using Delta Method.
}
\examples{
\dontrun{ 
# Average marginal effects
data("Health")
het.probit <- hetprob(working ~ factor(female) + factor(year) + educ + age + I(age^2) | 
                                factor(female) + age + I(age^2), 
                     data = Health, 
                     link = "probit")
summary(het.probit)
eff <- effect.hetprob(het.probit)
summary(eff)
}
}
