% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{RblUpload}
\alias{RblUpload}
\title{Upload a request file to Bloomberg}
\usage{
RblUpload(RblRequest, verbose = TRUE)
}
\arguments{
\item{RblRequest}{character string representing the request file according to Bloomberg Datalicense documentation. Can be generated with the \code{\link{RblRequestBuilder}} function}

\item{verbose}{logical. Should R report extra information on progress?}
}
\value{
A list with components
\describe{
 \item{req}{the request filename}
 \item{out}{the response filename}
}
}
\description{
Upload a request file to query Bloomberg. A response file will be generated by Bloomberg. 
The request file can be user-defined following the Bloomberg Data License documentation or generated with the \code{\link{RblRequestBuilder}} function.
The response file needs to be downloaded (see \code{\link{RblDownload}}) and parsed (see \code{\link{RblParse}}) to make data available in R.
}
\examples{
\dontrun{
# Run RblConnect first
RblRequest <- RblRequestBuilder(header = list(FIRMNAME = RblUser(), PROGRAMNAME = 'getdata'), 
                                fields = c('PX_LAST'), identifiers = c('SXXE Index'))
req <- RblUpload(RblRequest)
req
}

}
