\name{market.api.query.kraken}
\alias{market.api.query.kraken}
\title{Send request to kraken market API}
\usage{
market.api.query.kraken(url, key, secret, req = list(),
  verbose = getOption("Rbitcoin.verbose"))
}
\arguments{
  \item{url}{character with url on which query needs to be
  passed.}

  \item{key}{character API key used in private API calls.}

  \item{secret}{character API secret used in private API
  calls.}

  \item{req}{list of object passed to API: price and amount
  of opening order, id of cancelling order, etc.}

  \item{verbose}{integer. Rbitcoin processing messages,
  print to console if \code{verbose > 0}, each subfunction
  reduce \code{verbose} by 1. If missing then
  \code{getOption("Rbitcoin.verbose")} is used, by default
  \code{0}.}
}
\value{
R object created by fromJSON decoded result from market's
API call.
}
\description{
Send request to kraken market API.
}
\examples{
\dontrun{
# ticker
market.api.query.kraken(url = 'https://api.kraken.com/0/public/Ticker?pair=XBTCZEUR')
# wallet
market.api.query.kraken(url = 'https://api.kraken.com/0/private/Balance',
                        key = '', secret = '')
}
}
\references{
\url{https://www.kraken.com/help/api}
}
\seealso{
\code{\link{market.api.query}}
}

