\name{is.generic.rhea}
\alias{is.generic.rhea}
\title{
Check given reaction is generic reaction
}
\description{
Generic reaction is a reaction with at least one compound class as reaction participant (e.g., a primary alcohol + NADP -> an aldehyde + H(+) + NADPH). This function checks if given reaction is generic reaction
}
\usage{
is.generic.rhea(equation,chebi_df,id_col,parent_col,formula_col,direction_type)
}
\arguments{
  \item{equation}{
Reaction equation usually generated by get.rhea.all() function.
}
  \item{chebi_df}{
Chemial table data.frame() containing molecular formula and parent compound
}
  \item{id_col}{
In chemical table, choose the column name which contains chemical id (usually first column)
}
  \item{parent_col}{
In chemical table, choose the column name which contains parent compound ("parent" in chebi)
}
  \item{formula_col}{
In chemical table, choose the column name which contains molecular formula
}
  \item{direction_type}{
In reaction equation, provide reaction direction symbols. Default is c(' <\\\\?> ', ' <=> ', ' => ')
}
}
\value{
Logical TRUE/FALSE
}
\references{
Rhea: http://www.ebi.ac.uk/rhea \cr
ChEBI: http://www.ebi.ac.uk/chebi
}
\author{
Byoungnam Min <mbnmbn00@gmail.com>, Byeonghyuk Park, Kyoung Heon Kim and In-Geol Choi
}
\examples{
data(example) # Load example

chebi = example$chebi
rhea_generic = example$rhea_generic$equationWithChebi
rhea_massbal = example$rhea_massbal
rhea = c(rhea_generic, rhea_massbal)

# Check generic reaction
is.generic.rhea(rhea, chebi, id_col='chebi', parent_col='parent', 
  formula_col='formula', direction_type=c(' <=> ', ' <\\\\?> ', ' => '))
}
\keyword{ Rhea }
\keyword{ ChEBI }
\keyword{ Generic reaction }
