% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvt_write.R
\name{rvn_rvt_write}
\alias{rvn_rvt_write}
\title{Write Raven rvt file from Time Series}
\usage{
rvn_rvt_write(
  ts,
  params,
  units,
  dates = NULL,
  prd = NULL,
  tt = "00:00:00",
  dt = 1,
  ff = "raven_rvt_write.rvt"
)
}
\arguments{
\item{ts}{time series to write in xts or dataframe format}

\item{params}{the full string expression for the parameters line to write to file}

\item{units}{the full string expression for the units line to write to file}

\item{dates}{vector of date objects passed, necessary only if ts is not xts}

\item{prd}{period to use in writing rvt file, format "YYYY-MM-DD/YYYY-MM-DD"}

\item{tt}{initial start time to file}

\item{dt}{time interval to write to file}

\item{ff}{filename to write to without .rvt extension (added automatically)}
}
\value{
\item{flag}{returns TRUE if the function executed successfully}
}
\description{
rvn_rvt_write generates a Raven rvt file from a time series
}
\details{
This function writes the rvt file for a given time series dataset. The function will write out
the entirety of the columns provided in the given xts object. Please ensure that the
parameters supplied in the params and units objects match the xts object supplied.
}
\examples{

# load sample flow data
system.file('extdata','run1_Hydrographs.csv', package = "RavenR") \%>\%
rvn_hyd_read() -> mydata

# write time series to rvt file using data from subbasin 36
rvn_rvt_write(mydata$hyd$Sub36, params = "HYDROGRAPH", units = "m3/s",
  ff = file.path(tempdir(), 'raven_rvt_write'))

}
\seealso{
\code{\link{rvn_rvt_wsc}} to create an rvt file from Water Survey Canada (WSC) data
}
