% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_gen_gridweights.R
\name{rvn_gen_gridweights}
\alias{rvn_gen_gridweights}
\title{Generate Raven grid weights from shapefile}
\usage{
rvn_gen_gridweights(
  HRUshpfile,
  Gridshpfile,
  ValidHRUIDs = NULL,
  HRUIDcol = "HRU_ID",
  gridIDcol = "GridIDs",
  outfile = NULL
)
}
\arguments{
\item{HRUshpfile}{polygon shapefile (as sf or file path) of HRUs with data column containing HRU IDs (.shp extension expected)}

\item{Gridshpfile}{polygon shapefile (as sf or file path) of grid cells with data column containing cell IDs (.shp extension expected)}

\item{ValidHRUIDs}{a vector of valid HRU IDs in the model}

\item{HRUIDcol}{the name of the HRUshpfile polygon which contains the HRU IDs}

\item{gridIDcol}{the name of the Gridshpfile polygon which contains the cell IDs}

\item{outfile}{optional name of output Raven gaugeweights file}
}
\value{
\item{gridweights}{list with the number of HRUs, number of grid cells, and gridweights data frame.
Also writes the grid weights rvt file if outfile is supplied.}
}
\description{
Generates a Raven grid weights file given an HRU shapefile and a grid shapefile.
}
\details{
Generate grid weights file GaugeWeights.rvt given an HRU shapefile with HRU ID column
HRUIDcol (default 'HRU_ID') and a grid shapefile with ID column gridIDcol (default: 'cellID')
weights are determined by the areal overlap of grid cell g and HRU k, i.e.,
 wt[k][g]=area[k][g]/area[k]
where wt[k][g] is the weight of cell g in HRU k, area[k] is the total area of HRU k,
and area[k][g] is the area of HRU k that is within cell g.

By definition, the grid domain has to completely cover the HRU domain such that the sum of
wt[k][g] for any k, over all g, is 1.0. However, the script currently normalizes weights such that
all weights will sum to 1 for all HRUs where any portion of the HRU is overlapping with one or more
grid cells.

Not a tonne of QA/QC is currently included - can fail due to bad netCDF file or inappropriate UTM zone;
uses rgdal and rgeos libraries, and the accuracy of the gIntersection() routine
leaves something to be desired. The shapefiles should be in the same projection, which is
checked for in this function.

Note that the grid weights file (e.g. GridWeights.txt) is only written if outfile is not NULL. If
this is left as NULL, just the gridweights list object is returned. This object may be used to to
write the grid weights file using the \code{\link{rvn_gridweights_write}} function. If outfile is provided,
the \code{\link{rvn_gridweights_write}} function is called internally to write the gridweights file.
}
\examples{

# load example rvh file
nith <- system.file("extdata",'Nith.rvh', package = "RavenR")
rvh <- rvn_rvh_read(nith)

# adjust HRU shapefile to one per subbasin for demonstration
rvh$HRUtable <- rvh$HRUtable[c(1,6,15,25),]
rvh$HRUtable$Area <- rvh$SBtable$Area
rvh$HRUtable$ID <- rvh$HRUtable$SBID

# define HRU shapefile path (use subbasin shapefile for example)
hrushpfile <- system.file("extdata","Nith_shapefile_sample.shp",package = "RavenR")

# get grid shapefile from netcdf file
nithnc <- system.file("extdata/Nith_era5_sample.nc", package="RavenR")
gridshp <- rvn_netcdf_to_gridshp(ncfile=nithnc, projID=26917)

# calculate gridweights
gw <- rvn_gen_gridweights(hrushpfile, gridshp,
gridIDcol = 'GridIDs', HRUIDcol = "subID")


}
\seealso{
\code{\link{rvn_netcdf_to_gridshp}} for converting netcdf files to grid shapefile format
}
\author{
James R. Craig, University of Waterloo, 2019
}
