% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_df_to_Raven_table.R
\name{rvn_df_to_Raven_table}
\alias{rvn_df_to_Raven_table}
\title{Sets up tables for writing to Raven input files}
\usage{
rvn_df_to_Raven_table(attributes, units, df, id_col = TRUE, parameters = FALSE)
}
\arguments{
\item{attributes}{array of strings containing attribute/parameter names}

\item{units}{array of strings with the corresponding units}

\item{df}{Dataframe of values corresponding to attributes/parameters}

\item{id_col}{True/False of whether an numeric id column is the first column in the table
and, in common Raven fashion, does not have a corresponding attribute (default: True)}

\item{parameters}{bool, when adding attribues/parameter tag, should ':Parameters' be used instead of ':Attributes'?}
}
\value{
outdf data.frame object
}
\description{
Sets up tables for writing to Raven input files
}
\examples{
soil_classes <- data.frame('Attributes' = c('DEFAULT','ALTERNATIVE'),
                           'SAND'      = c(0.4316, 0.3000),
                           'CLAY'      = c(0.1684, 0.4000),
                           'SILT'      = c(0.4000, 0.3000),
                           'ORGANIC'   = c(0.0000, 0.0000))
attributes <- c('\%SAND','\%CLAY','\%SILT','\%ORGANIC')
units <-  rep('none',4)
soil_classes <- rvn_df_to_Raven_table(attributes, units, soil_classes)
print(soil_classes)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
