% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_kemeny.R
\name{mod_kemeny}
\alias{mod_kemeny}
\title{Modified Kemeny Rank Aggregation}
\usage{
mod_kemeny(input_rkgs, universe_rkgs, obj_pairs)
}
\arguments{
\item{input_rkgs}{a \code{k} by \code{n} matrix of \code{k} rankings of \code{n}
objects, where each row is a complete ranking. Note that this is a transpose of
matrix used for functions like \code{fur}, \code{sigfur}, \code{rap_greedy_alg},
and \code{subit_convergence}.}

\item{universe_rkgs}{a matrix containing all possible permutations of ranking
n objects. Each row in this matrix represents one permuted ranking.}

\item{obj_pairs}{a \code{2} by \code{n choose 2} matrix of all combinations of
object pairs of n objects, where each column contains a pair of object indices.}
}
\value{
A list containing the consensus ranking (expressed as ordering), total Kemeny distance, and average
tau correlation coefficient corresponding to the consensus ranking.
}
\description{
\emph{Modified Kemeny} algorithm determines the consensus ranking of \code{n} objects using
the set of all possible rankings compared to the input rankings. The algorithm is based on
Kemeny's axiomatic approach of minimizing the total Kemeny distance from the input rankings.
In case of multiple rankings with minimum total Kemeny distance, the consensus ranking is
determined using two additional criteria. See `Details' for additional criteria.
The method involves \code{n}! comparisons. Hence, it works best on a set of rankings with a small
number of objects.
}
\details{
Under Kemeny's axiomatic approach, rankings with minimum total Kemeny distance are
considered equally optimal. Modified Kemeny attempts to break the tie among such rankings by
imposing two additional criteria on the basis of minimizing (a) the maximum and (b) the variance
of individual Kemeny distances, applied sequentially.
}
\examples{
## Consensus ranking from four rankings of five objects
n <- 5
input_rkgs <- matrix(c(3, 2, 5, 1, 2, 3, 1, 2, 5, 1, 3, 4, 4, 5, 4, 5, 1, 4, 2, 3), ncol = n)
uni_rkgs <- matrix(unlist(combinat::permn(c(1:n))), byrow = TRUE, ncol = n)
obj_pairs <- combinat::combn(1:n,2, simplify=TRUE)
mod_kemeny(input_rkgs, uni_rkgs, obj_pairs) # Computed consensus ranking, total Kemeny distance,
                                            # and average tau correlation coefficient

}
\references{
Badal, P. S., & Das, A. (2018). Efficient algorithms using subiterative
convergence for Kemeny ranking problem. Computers & Operations Research, 98, 198-210.
\doi{10.1016/j.cor.2018.06.007}
}
