% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper-functions.R
\name{summary.radviz}
\alias{summary.radviz}
\alias{head.radviz}
\alias{dim.radviz}
\alias{print.radviz}
\alias{springs}
\title{Radviz Object Summary, head, print, dim and springs Methods}
\usage{
\method{summary}{radviz}(object, ..., n = 6)

\method{head}{radviz}(x, n = 6, ...)

\method{dim}{radviz}(x)

\method{print}{radviz}(x, ...)

springs(x)
}
\arguments{
\item{object}{an object of class Radviz, as returned by \code{\link{do.radviz}}}

\item{...}{further arguments to be passed to or from other methods (not implemented)}

\item{n}{the number of lines from each slots in the Radviz object to display (defaults to 6)}

\item{x}{an object of class Radviz, as returned by \code{\link{do.radviz}}}
}
\description{
Provides a summary for Radviz objects
}
\details{
\code{dim} returns the number of points and the number of dimensions 
used for the projection.
\code{print} returns invisibly the data, including the projected coordinates
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)

summary(rv)
head(rv)
dim(rv)
print(rv)

}
\author{
Yann Abraham
}
