% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recenter.R
\name{recenter}
\alias{recenter}
\title{Rotate Dimensional Anchors around the Unit Circle}
\usage{
recenter(springs, newc)
}
\arguments{
\item{springs}{a spring object as created by \code{\link{make.S}}}

\item{newc}{a string specifying which dimensional anchor should be placed on top of the unit circle}
}
\value{
a spring object with rotated labels
}
\description{
recenter will rotate the order of the dimensional anchors around the circle, to put a channel
of reference to the top of the display.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
iris.S <- make.S(das)
iris.S
recenter(iris.S,'Petal.Length')

}
\author{
Yann Abraham
}

