% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{tableDistances}
\alias{tableDistances}
\title{Return calculated table distances for an acmap}
\usage{
tableDistances(map, optimization_number = 1)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The optimization number}
}
\value{
Returns a matrix of numeric table distances
}
\description{
Takes the acmap object and, assuming the column bases associated with the
currently selected or specified optimization, returns the table distances
calculated from the titer data. For more information on column bases and
their role in antigenic cartography see
\code{vignette("intro-to-antigenic-cartography")}
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
