% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{tableColbases}
\alias{tableColbases}
\title{Calculate column bases for a titer table}
\usage{
tableColbases(
  titer_table,
  minimum_column_basis = "none",
  fixed_column_bases = rep(NA, ncol(titer_table)),
  ag_reactivity_adjustments = rep(0, nrow(titer_table))
)
}
\arguments{
\item{titer_table}{The titer table}

\item{minimum_column_basis}{The minimum column basis to assume}

\item{fixed_column_bases}{Fixed column bases to apply}

\item{ag_reactivity_adjustments}{Reactivity adjustments to apply on a per-antigen basis}
}
\value{
Returns a numeric vector of the log-converted column bases for the
table
}
\description{
For more information on column bases, what they mean and how they are
calculated see \code{vignette("intro-to-antigenic-cartography")}
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
