% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{maxNoisyGenesTB}
\alias{maxNoisyGenesTB}
\title{Function for extracting genes maximal variability}
\usage{
maxNoisyGenesTB(noise, cl = NULL, set = NULL, minobs = 5)
}
\arguments{
\item{noise}{List object with noise parameters returned by the \code{compTBNoise} function.}

\item{cl}{List object with clustering information, returned by the \code{graphCluster} function. Default is \code{NULL}.}

\item{set}{Postive integer number or vector of integers corresponding to valid cluster numbers. Noise levels are computed across all cells in this subset of clusters. Default is \code{NULL} and noise levels are computed across all cells.}

\item{minobs}{Positive integer number. Only genes with at least \code{minobs} neighbourhoods with non-zero biological noise levels in \code{set} are included. Default is 5.}
}
\value{
Vector with average gene expression variability in decreasing order, computed across all cells or only cells in a set of clusters (if \code{cl} and
\code{set} are given.
}
\description{
This function extracts genes with maximal variability in a cluster or in the entire data set.
}
\examples{
res <- pruneKnn(intestinalDataSmall,knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compNoise(intestinalDataSmall,res,pvalue=0.01,genes = NULL,no_cores=1)
mgenes <- maxNoisyGenes(noise)
}
