% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzxmlFunctions.R
\name{grabMzxmlMS3}
\alias{grabMzxmlMS3}
\title{Extract the MS3 data from an mzXML nodeset}
\usage{
grabMzxmlMS3(xml_data, file_metadata, rtrange, incl_polarity)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzXML file.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{incl_polarity}{Boolean determining whether the polarity of the scan
should be returned as a column in the table (positive mode = 1, negative
mode = -1)}
}
\value{
A `data.table` with columns for retention time (rt),
MS1 precursor m/z (prepremz), MS2 precursor m/z (premz),
fragment m/z (fragmz), collision energy (voltage), and intensity (int).
}
\description{
Extract the MS3 data from an mzXML nodeset
}
