% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_crandb.R
\name{s_crandb}
\alias{s_crandb}
\alias{s_crandb_list}
\alias{s_crandb_PTD}
\alias{s_crandb_AM}
\title{Search Packages by Keywords in data.frame crandb}
\usage{
s_crandb(..., char = NULL, select = "PTD", mode = "or",
  sensitive = FALSE, perl = FALSE, fixed = FALSE, agrep = FALSE,
  max.distance = 0.1, costs = NULL, crandb = get("crandb", envir =
  .GlobalEnv))

s_crandb_list(..., char = NULL, select = "PTD", mode = "or",
  sensitive = FALSE, perl = FALSE, fixed = FALSE, agrep = FALSE,
  max.distance = 0.1, costs = NULL, crandb = get("crandb", envir =
  .GlobalEnv))

s_crandb_PTD(..., char = NULL, mode = "or", sensitive = FALSE,
  perl = FALSE, fixed = FALSE, agrep = FALSE, max.distance = 0.1,
  costs = NULL, crandb = get("crandb", envir = .GlobalEnv))

s_crandb_AM(..., char = NULL, mode = "or", sensitive = FALSE,
  perl = FALSE, fixed = FALSE, agrep = FALSE, max.distance = 0.1,
  costs = NULL, crandb = get("crandb", envir = .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, except list.
One or several keywords.}

\item{char}{(name to) a character vector. Use this argument if \code{...} fails 
or if you call the function from another function. If used, 
argument \code{...} is ignored.}

\item{select}{character vector. A sub-vector of \code{colnames(crandb)}. The 
short form "P", "T", "D", "PT", "PD", "TD", "PTD", "A", "M", "AM" 
describing the Package name, Title, Description, Author, Maintainer
or a combination of them is accepted.}

\item{mode}{character among "or", "and", "relax". The search mode. 
"relax" is for 3 words and more. It is an intermediate between 
"or" and "and" as it requires just 2 matching words: 
\code{("word1" AND "word2")} \code{OR} \code{("word1" AND "word3")} 
\code{OR} \code{("word1" AND "word3")}.}

\item{sensitive}{logical. \code{TRUE} forces the search to be case sensitive.}

\item{perl}{logical. Used only if \code{fixed = FALSE}. \code{TRUE} uses 
Perl-compatible regex. \code{FALSE} uses default regexps.}

\item{fixed}{logical. \code{TRUE} matchs the keywords as is (and \code{sensitive} 
is forced to \code{TRUE}). \code{FALSE} allows grep or Perl regexps. 
See \code{\link[base]{grep}}. Not used by \code{agrep}.}

\item{agrep}{logical. For approximate matching, use \code{\link[base]{agrep}} 
function rather than grep.}

\item{max.distance}{integer or numeric. See \code{\link[base]{agrep}}.}

\item{costs}{NULL or list. See \code{\link[base]{agrep}}.}

\item{crandb}{data.frame \code{crandb}.}
}
\description{
The most important functions in this package along with \code{\link{p_down}}.

Search packages in data.frame \code{crandb} that contain one or several keywords 
in the columns "Package", "Title", "Description", "Author" or "Maintainer". 

\code{s_crandb} returns a vector of the packages that contain the keywords. 

\code{s_crandb_list} returns a list where each element of the list is one of the 
keywords. 

\code{s_crandb_PTD} returns a list split by results in columns "Package", "Title" 
and "Description". Option \code{mode = "and", "relax"} is ignored.

\code{s_crandb_AM} returns a list split by results in columns "Author" and
"Maintainer". Option \code{mode = "and", "relax"} is ignored.

Use \code{\link{p_table2}} to print the results of \code{s_crandb} and
\code{s_crandb_list} in the console. 
Use \code{\link{p_text}} to send the results in txt, md or pdf files. 
Use \code{\link{p_display}} to visualize the results in html pages in the browser.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

## Search using standard or non-standard content
s_crandb(c("thermodynamic", "chemical reaction", "distillation"))
s_crandb_list(thermodynamic, "chemical reaction", distillation)

## Search using the various options
s_crandb(pH, sensitive = TRUE)
s_crandb_PTD(pH, sensitive = TRUE)
s_crandb_PTD("C++", fixed = TRUE)
s_crandb(search, find, cran, web, select = "PD", mode = "and")
s_crandb(search, find, cran, web, select = "PD", mode = "relax")
s_crandb(search, find, cran, web, select = "PD", mode = "or")

## Search for some authors using the various options
s_crandb_AM(Kiener, Dutang, ORPHANED)

## Non-standard content can be unquoted words or objects in .GlobalEnv
## They are transformed into character or are evaluated 
## Here, the searched keywords are "find" and "search".
OTHER <- "search"
(lst <- s_crandb_list(find, OTHER, select = "P", sensitive = TRUE)) 
\donttest{
## Display in the browser this list of packages
p_display5(lst, dir = tempdir())
}

}
