/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.util.List;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionFinishedCallback;
import weka.knowledgeflow.FlowRunner;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.StepTask;
import weka.knowledgeflow.steps.Step;

public class StepInjectorFlowRunner
extends FlowRunner {
    protected boolean m_reset = true;
    protected boolean m_streaming;

    public void reset() {
        this.m_reset = true;
        this.m_streaming = false;
    }

    public void injectWithExecutionFinishedCallback(final Data toInject, ExecutionFinishedCallback callback, final Step target) throws WekaException {
        if (StepManagerImpl.connectionIsIncremental(toInject)) {
            throw new WekaException("Only batch data can be injected via this method.");
        }
        this.addExecutionFinishedCallback(callback);
        String connName = toInject.getConnectionName();
        List<String> accceptableInputs = target.getIncomingConnectionTypes();
        if (!accceptableInputs.contains(connName)) {
            throw new WekaException("Step '" + target.getName() + "' can't accept a " + connName + " input at present!");
        }
        this.initializeFlow();
        this.m_execEnv.submitTask(new StepTask<Void>(null){
            private static final long serialVersionUID = 663985401825979869L;

            @Override
            public void process() throws Exception {
                target.processIncoming(toInject);
            }
        });
        this.m_logHandler.logDebug("StepInjectorFlowRunner: Launching shutdown monitor");
        this.launchExecutorShutdownThread();
    }

    public Step findStep(String stepName, Class stepClass) throws WekaException {
        if (this.m_flow == null) {
            throw new WekaException("No flow set!");
        }
        StepManagerImpl manager = this.m_flow.findStep(stepName);
        if (manager == null) {
            throw new WekaException("Step '" + stepName + "' does not seem to be part of the flow!");
        }
        Step target = manager.getManagedStep();
        if (target.getClass() != stepClass) {
            throw new WekaException("Step '" + stepName + "' is not an instance of " + stepClass.getCanonicalName());
        }
        if (target.getIncomingConnectionTypes() == null || target.getIncomingConnectionTypes().size() == 0) {
            throw new WekaException("Step '" + stepName + "' cannot process any incoming data!");
        }
        return target;
    }

    public void injectStreaming(Data toInject, Step target, boolean lastData) throws WekaException {
        if (this.m_reset) {
            if (this.m_streaming) {
                this.m_execEnv.stopClientExecutionService();
            }
            String connName = toInject.getConnectionName();
            List<String> accceptableInputs = target.getIncomingConnectionTypes();
            if (!accceptableInputs.contains(connName)) {
                throw new WekaException("Step '" + target.getName() + "' can't accept a " + connName + " input at present!");
            }
            this.initializeFlow();
            toInject.setPayloadElement("incremental_stream_end", false);
            this.m_streaming = true;
            this.m_reset = false;
        }
        if (lastData) {
            toInject.setPayloadElement("incremental_stream_end", true);
        }
        target.processIncoming(toInject);
        if (lastData) {
            this.m_logHandler.logDebug("StepInjectorFlowRunner: Shutting down executor service");
            this.m_execEnv.stopClientExecutionService();
            this.reset();
        }
    }
}

