/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NumericTransform
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -8561413333351366934L;
    private Range m_Cols = new Range();
    private String m_Class = "java.lang.Math";
    private String m_Method = "abs";

    public String globalInfo() {
        return "Transforms numeric attributes using a given transformation method.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (this.m_Class == null) {
            throw new IllegalStateException("No class has been set.");
        }
        if (this.m_Method == null) {
            throw new IllegalStateException("No method has been set.");
        }
        super.setInputFormat(instanceInfo);
        this.m_Cols.setUpper(instanceInfo.numAttributes() - 1);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Method m = Class.forName(this.m_Class).getMethod(this.m_Method, Double.TYPE);
        double[] vals = new double[instance.numAttributes()];
        Double[] params = new Double[1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (instance.isMissing(i)) {
                vals[i] = Utils.missingValue();
                continue;
            }
            if (this.m_Cols.isInRange(i) && instance.attribute(i).isNumeric()) {
                params[0] = new Double(instance.value(i));
                Double newVal = (Double)m.invoke(null, (Object[])params);
                if (newVal.isNaN() || newVal.isInfinite()) {
                    vals[i] = Utils.missingValue();
                    continue;
                }
                vals[i] = newVal;
                continue;
            }
            vals[i] = instance.value(i);
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(instance.dataset());
        this.push(inst);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify list of columns to transform. First and last are\n\tvalid indexes (default none). Non-numeric columns are \n\tskipped.", "R", 1, "-R <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        newVector.addElement(new Option("\tSets the class containing transformation method.\n\t(default java.lang.Math)", "C", 1, "-C <string>"));
        newVector.addElement(new Option("\tSets the method. (default abs)", "M", 1, "-M <string>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String methodString;
        this.setAttributeIndices(Utils.getOption('R', options));
        this.setInvertSelection(Utils.getFlag('V', options));
        String classString = Utils.getOption('C', options);
        if (classString.length() != 0) {
            this.setClassName(classString);
        }
        if ((methodString = Utils.getOption('M', options)).length() != 0) {
            this.setMethodName(methodString);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[7];
        int current = 0;
        if (this.getInvertSelection()) {
            options[current++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            options[current++] = "-R";
            options[current++] = this.getAttributeIndices();
        }
        if (this.m_Class != null) {
            options[current++] = "-C";
            options[current++] = this.getClassName();
        }
        if (this.m_Method != null) {
            options[current++] = "-M";
            options[current++] = this.getMethodName();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String classNameTipText() {
        return "Name of the class containing the method used for the transformation.";
    }

    public String getClassName() {
        return this.m_Class;
    }

    public void setClassName(String name) throws ClassNotFoundException {
        this.m_Class = name;
    }

    public String methodNameTipText() {
        return "Name of the method used for the transformation.";
    }

    public String getMethodName() {
        return this.m_Method;
    }

    public void setMethodName(String name) throws NoSuchMethodException {
        this.m_Method = name;
    }

    public String invertSelectionTipText() {
        return "Whether to process the inverse of the given attribute ranges.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_Cols.setInvert(invert);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String rangeList) {
        this.m_Cols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        NumericTransform.runFilter(new NumericTransform(), argv);
    }
}

