/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans.xml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.DatabaseSaver;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.TextDirectoryLoader;
import weka.core.xml.XMLBasicSerialization;
import weka.core.xml.XMLDocument;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.Classifier;
import weka.gui.beans.Clusterer;
import weka.gui.beans.Filter;
import weka.gui.beans.Loader;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Saver;
import weka.gui.beans.Visible;

public class XMLBeans
extends XMLBasicSerialization {
    public static final String VAL_ID = "id";
    public static final String VAL_X = "x";
    public static final String VAL_Y = "y";
    public static final String VAL_BEAN = "bean";
    public static final String VAL_CUSTOM_NAME = "custom_name";
    public static final String VAL_SOURCEID = "source_id";
    public static final String VAL_TARGETID = "target_id";
    public static final String VAL_EVENTNAME = "eventname";
    public static final String VAL_HIDDEN = "hidden";
    public static final String VAL_FILE = "file";
    public static final String VAL_DIR = "dir";
    public static final String VAL_PREFIX = "prefix";
    public static final String VAL_RELATIVE_PATH = "useRelativePath";
    public static final String VAL_OPTIONS = "options";
    public static final String VAL_SAVER = "wrappedAlgorithm";
    public static final String VAL_LOADER = "wrappedAlgorithm";
    public static final String VAL_TEXT = "text";
    public static final String VAL_BEANCONTEXT = "beanContext";
    public static final String VAL_WIDTH = "width";
    public static final String VAL_HEIGHT = "height";
    public static final String VAL_RED = "red";
    public static final String VAL_GREEN = "green";
    public static final String VAL_BLUE = "blue";
    public static final String VAL_NAME = "name";
    public static final String VAL_STYLE = "style";
    public static final String VAL_LOCATION = "location";
    public static final String VAL_SIZE = "size";
    public static final String VAL_COLOR = "color";
    public static final String VAL_FONT = "font";
    public static final String VAL_ICONPATH = "iconPath";
    public static final String VAL_ANIMATEDICONPATH = "animatedIconPath";
    public static final String VAL_ASSOCIATEDCONNECTIONS = "associatedConnections";
    public static final String VAL_INPUTS = "inputs";
    public static final String VAL_INPUTSID = "inputs_id";
    public static final String VAL_OUTPUTS = "outputs";
    public static final String VAL_OUTPUTSID = "outputs_id";
    public static final String VAL_SUBFLOW = "subFlow";
    public static final String VAL_ORIGINALCOORDS = "originalCoords";
    public static final String VAL_RELATIONNAMEFORFILENAME = "relationNameForFilename";
    public static final int INDEX_BEANINSTANCES = 0;
    public static final int INDEX_BEANCONNECTIONS = 1;
    protected JComponent m_BeanLayout;
    protected Vector m_BeanInstances;
    protected Vector m_BeanInstancesID;
    protected boolean m_IgnoreBeanConnections;
    protected MetaBean m_CurrentMetaBean;
    protected static final String REGULAR_CONNECTION = "regular_connection";
    protected Hashtable m_BeanConnectionRelation;
    public static final int DATATYPE_LAYOUT = 0;
    public static final int DATATYPE_USERCOMPONENTS = 1;
    protected int m_DataType = 0;
    protected BeanContextSupport m_BeanContextSupport = null;

    public XMLBeans(JComponent layout, BeanContextSupport context) throws Exception {
        this(layout, context, 0);
    }

    public XMLBeans(JComponent layout, BeanContextSupport context, int datatype) throws Exception {
        this.m_BeanLayout = layout;
        this.m_BeanContextSupport = context;
        this.setDataType(datatype);
    }

    public void setDataType(int value) {
        if (value == 0) {
            this.m_DataType = value;
        } else if (value == 1) {
            this.m_DataType = value;
        } else {
            System.out.println("DataType '" + value + "' is unknown!");
        }
    }

    public int getDataType() {
        return this.m_DataType;
    }

    @Override
    public void clear() throws Exception {
        int i;
        super.clear();
        this.m_Properties.addIgnored("UI");
        this.m_Properties.addIgnored("actionMap");
        this.m_Properties.addIgnored("alignmentX");
        this.m_Properties.addIgnored("alignmentY");
        this.m_Properties.addIgnored("autoscrolls");
        this.m_Properties.addIgnored("background");
        this.m_Properties.addIgnored("border");
        this.m_Properties.addIgnored("componentPopupMenu");
        this.m_Properties.addIgnored("debugGraphicsOptions");
        this.m_Properties.addIgnored("doubleBuffered");
        this.m_Properties.addIgnored("enabled");
        this.m_Properties.addIgnored("focusCycleRoot");
        this.m_Properties.addIgnored("focusTraversalPolicy");
        this.m_Properties.addIgnored("focusTraversalPolicyProvider");
        this.m_Properties.addIgnored("focusable");
        this.m_Properties.addIgnored(VAL_FONT);
        this.m_Properties.addIgnored("foreground");
        this.m_Properties.addIgnored("inheritsPopupMenu");
        this.m_Properties.addIgnored("inputVerifier");
        this.m_Properties.addIgnored("layout");
        this.m_Properties.addIgnored("locale");
        this.m_Properties.addIgnored("maximumSize");
        this.m_Properties.addIgnored("minimumSize");
        this.m_Properties.addIgnored("nextFocusableComponent");
        this.m_Properties.addIgnored("opaque");
        this.m_Properties.addIgnored("preferredSize");
        this.m_Properties.addIgnored("requestFocusEnabled");
        this.m_Properties.addIgnored("toolTipText");
        this.m_Properties.addIgnored("transferHandler");
        this.m_Properties.addIgnored("verifyInputWhenFocusTarget");
        this.m_Properties.addIgnored("visible");
        this.m_Properties.addIgnored(VAL_SIZE);
        this.m_Properties.addIgnored(VAL_LOCATION);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_X);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_Y);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_BEAN);
        this.m_Properties.addAllowed(Saver.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(Loader.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(Saver.class, VAL_RELATIONNAMEFORFILENAME);
        if (this.getDataType() == 0) {
            this.m_Properties.addAllowed(Loader.class, VAL_BEANCONTEXT);
        } else {
            this.m_Properties.addIgnored(Loader.class, VAL_BEANCONTEXT);
        }
        this.m_Properties.addAllowed(Filter.class, "filter");
        this.m_Properties.addAllowed(Classifier.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(Clusterer.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(Classifier.class, "executionSlots");
        this.m_Properties.addAllowed(Classifier.class, "blockOnLastFold");
        this.m_Properties.addAllowed(weka.classifiers.Classifier.class, "debug");
        this.m_Properties.addAllowed(weka.classifiers.Classifier.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(weka.filters.Filter.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(DatabaseSaver.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(DatabaseLoader.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(TextDirectoryLoader.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(SplitEvaluator.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(ResultProducer.class, VAL_OPTIONS);
        this.m_CustomMethods.register(this, Color.class, "Color");
        this.m_CustomMethods.register(this, Dimension.class, "Dimension");
        this.m_CustomMethods.register(this, Font.class, "Font");
        this.m_CustomMethods.register(this, Point.class, "Point");
        this.m_CustomMethods.register(this, ColorUIResource.class, "ColorUIResource");
        this.m_CustomMethods.register(this, FontUIResource.class, "FontUIResource");
        this.m_CustomMethods.register(this, BeanInstance.class, "BeanInstance");
        this.m_CustomMethods.register(this, BeanConnection.class, "BeanConnection");
        this.m_CustomMethods.register(this, BeanVisual.class, "BeanVisual");
        this.m_CustomMethods.register(this, Saver.class, "BeanSaver");
        this.m_CustomMethods.register(this, MetaBean.class, "MetaBean");
        Vector<String> classnames = ConverterUtils.getFileLoaders();
        for (i = 0; i < classnames.size(); ++i) {
            this.m_CustomMethods.register(this, Class.forName(classnames.get(i)), "Loader");
        }
        classnames = ConverterUtils.getFileSavers();
        for (i = 0; i < classnames.size(); ++i) {
            this.m_CustomMethods.register(this, Class.forName(classnames.get(i)), "Saver");
        }
        this.m_BeanInstances = null;
        this.m_BeanInstancesID = null;
        this.m_CurrentMetaBean = null;
        this.m_IgnoreBeanConnections = true;
        this.m_BeanConnectionRelation = null;
    }

    protected void addBeanInstances(Vector list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof BeanInstance) {
                BeanInstance beaninst = (BeanInstance)list.get(i);
                this.m_BeanInstancesID.add(new Integer(this.m_BeanInstances.size()));
                this.m_BeanInstances.add(beaninst);
                if (!(beaninst.getBean() instanceof MetaBean)) continue;
                this.addBeanInstances(((MetaBean)beaninst.getBean()).getBeansInSubFlow());
                continue;
            }
            if (list.get(i) instanceof MetaBean) {
                this.addBeanInstances(((MetaBean)list.get(i)).getBeansInSubFlow());
                continue;
            }
            System.out.println("addBeanInstances does not support Vectors of class '" + list.get(i) + "'!");
        }
    }

    @Override
    protected Object writePreProcess(Object o) throws Exception {
        o = super.writePreProcess(o);
        this.m_BeanInstances = new Vector();
        this.m_BeanInstancesID = new Vector();
        switch (this.getDataType()) {
            case 0: {
                this.addBeanInstances(BeanInstance.getBeanInstances());
                break;
            }
            case 1: {
                this.addBeanInstances((Vector)o);
                break;
            }
            default: {
                System.out.println("writePreProcess: data type '" + this.getDataType() + "' is not recognized!");
            }
        }
        return o;
    }

    @Override
    protected void writePostProcess(Object o) throws Exception {
        if (this.getDataType() == 0) {
            Element root = this.m_Document.getDocument().getDocumentElement();
            Element conns = (Element)root.getChildNodes().item(1);
            NodeList list = conns.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element child = (Element)list.item(i);
                child.setAttribute(VAL_NAME, "" + i);
            }
        }
    }

    @Override
    protected Document readPreProcess(Document document) throws Exception {
        this.m_BeanInstances = new Vector();
        this.m_BeanInstancesID = new Vector();
        NodeList list = document.getElementsByTagName("*");
        String clsName = BeanInstance.class.getName();
        for (int i = 0; i < list.getLength(); ++i) {
            Element node = (Element)list.item(i);
            if (!node.getAttribute("class").equals(clsName)) continue;
            Vector<Element> children = XMLDocument.getChildTags(node);
            int id = this.m_BeanInstancesID.size();
            for (int n = 0; n < children.size(); ++n) {
                Element child = children.get(n);
                if (!child.getAttribute(VAL_NAME).equals(VAL_ID)) continue;
                id = this.readIntFromXML(child);
            }
            this.m_BeanInstancesID.add(new Integer(id));
        }
        this.m_BeanInstances.setSize(this.m_BeanInstancesID.size());
        this.m_CurrentMetaBean = null;
        this.m_IgnoreBeanConnections = true;
        this.m_BeanConnectionRelation = new Hashtable();
        return document;
    }

    protected void setBeanConnection(BeanConnection conn, Vector list) {
        boolean added = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) continue;
            list.set(i, conn);
            added = true;
            break;
        }
        if (!added) {
            list.add(conn);
        }
    }

    protected BeanConnection createBeanConnection(int sourcePos, int targetPos, String event, boolean hidden) throws Exception {
        BeanConnection result = null;
        if (sourcePos == -1 || targetPos == -1) {
            return result;
        }
        BeanInstance instSource = (BeanInstance)this.m_BeanInstances.get(sourcePos);
        BeanInstance instTarget = (BeanInstance)this.m_BeanInstances.get(targetPos);
        BeanInfo compInfo = Introspector.getBeanInfo(((BeanInstance)this.m_BeanInstances.get(sourcePos)).getBean().getClass());
        EventSetDescriptor[] esds = compInfo.getEventSetDescriptors();
        for (int i = 0; i < esds.length; ++i) {
            if (!esds[i].getName().equals(event)) continue;
            result = new BeanConnection(instSource, instTarget, esds[i]);
            result.setHidden(hidden);
            break;
        }
        return result;
    }

    protected void rebuildBeanConnections(Vector deserialized, Object key) throws Exception {
        Vector conns = (Vector)this.m_BeanConnectionRelation.get(key);
        if (conns == null) {
            return;
        }
        for (int n = 0; n < conns.size(); ++n) {
            StringTokenizer tok = new StringTokenizer(conns.get(n).toString(), ",");
            BeanConnection conn = null;
            int sourcePos = Integer.parseInt(tok.nextToken());
            int targetPos = Integer.parseInt(tok.nextToken());
            String event = tok.nextToken();
            boolean hidden = this.stringToBoolean(tok.nextToken());
            if (!(key instanceof MetaBean) || this.getDataType() == 1) {
                conn = this.createBeanConnection(sourcePos, targetPos, event, hidden);
            } else {
                Vector beanconns = BeanConnection.getConnections();
                for (int i = 0; !(i >= beanconns.size() || (conn = (BeanConnection)beanconns.get(i)).getSource() == (BeanInstance)this.m_BeanInstances.get(sourcePos) && conn.getTarget() == (BeanInstance)this.m_BeanInstances.get(targetPos) && conn.getEventName().equals(event)); ++i) {
                    conn = null;
                }
            }
            if (key instanceof MetaBean) {
                this.setBeanConnection(conn, ((MetaBean)key).getAssociatedConnections());
                continue;
            }
            this.setBeanConnection(conn, (Vector)deserialized.get(1));
        }
    }

    protected void removeUserToolBarBeans(Vector metabeans) {
        for (int i = 0; i < metabeans.size(); ++i) {
            MetaBean meta = (MetaBean)metabeans.get(i);
            Vector subflow = meta.getSubFlow();
            for (int n = 0; n < subflow.size(); ++n) {
                BeanInstance beaninst = (BeanInstance)subflow.get(n);
                beaninst.removeBean(this.m_BeanLayout);
            }
        }
    }

    @Override
    protected Object readPostProcess(Object o) throws Exception {
        Vector deserialized = (Vector)super.readPostProcess(o);
        this.rebuildBeanConnections(deserialized, REGULAR_CONNECTION);
        Enumeration enm = this.m_BeanConnectionRelation.keys();
        while (enm.hasMoreElements()) {
            Object key = enm.nextElement();
            if (!(key instanceof MetaBean)) continue;
            this.rebuildBeanConnections(deserialized, key);
        }
        if (this.getDataType() == 1) {
            this.removeUserToolBarBeans(deserialized);
        }
        return deserialized;
    }

    protected Vector getBeanConnectionRelation(MetaBean meta) {
        Object key = meta == null ? REGULAR_CONNECTION : meta;
        if (!this.m_BeanConnectionRelation.containsKey(key)) {
            this.m_BeanConnectionRelation.put(key, new Vector());
        }
        Vector result = (Vector)this.m_BeanConnectionRelation.get(key);
        return result;
    }

    protected void addBeanConnectionRelation(MetaBean meta, String connection) {
        Vector relations = this.getBeanConnectionRelation(meta);
        relations.add(connection);
        Object key = meta == null ? REGULAR_CONNECTION : meta;
        this.m_BeanConnectionRelation.put(key, relations);
    }

    public Element writeColor(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Color color = (Color)o;
        Element node = this.addElement(parent, name, color.getClass().getName(), false);
        this.writeIntToXML(node, color.getRed(), VAL_RED);
        this.writeIntToXML(node, color.getGreen(), VAL_GREEN);
        this.writeIntToXML(node, color.getBlue(), VAL_BLUE);
        return node;
    }

    public Object readColor(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Color result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_RED)) {
                red = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_GREEN)) {
                green = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_BLUE)) {
                blue = this.readIntFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new Color(red, green, blue);
        return result;
    }

    public Element writeDimension(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Dimension dim = (Dimension)o;
        Element node = this.addElement(parent, name, dim.getClass().getName(), false);
        this.writeDoubleToXML(node, dim.getWidth(), VAL_WIDTH);
        this.writeDoubleToXML(node, dim.getHeight(), VAL_HEIGHT);
        return node;
    }

    public Object readDimension(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Dimension result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        double width = 0.0;
        double height = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_WIDTH)) {
                width = this.readDoubleFromXML(child);
                continue;
            }
            if (name.equals(VAL_HEIGHT)) {
                height = this.readDoubleFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new Dimension();
        result.setSize(width, height);
        return result;
    }

    public Element writeFont(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Font font = (Font)o;
        Element node = this.addElement(parent, name, font.getClass().getName(), false);
        this.invokeWriteToXML(node, font.getName(), VAL_NAME);
        this.writeIntToXML(node, font.getStyle(), VAL_STYLE);
        this.writeIntToXML(node, font.getSize(), VAL_SIZE);
        return node;
    }

    public Object readFont(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Font result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        String fontname = "";
        int style = 0;
        int size = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_NAME)) {
                name = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_STYLE)) {
                style = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_SIZE)) {
                size = this.readIntFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new Font(fontname, style, size);
        return result;
    }

    public Element writePoint(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Point p = (Point)o;
        Element node = this.addElement(parent, name, p.getClass().getName(), false);
        this.writeDoubleToXML(node, p.getX(), VAL_X);
        this.writeDoubleToXML(node, p.getY(), VAL_Y);
        return node;
    }

    public Object readPoint(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Point result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_X)) {
                x = this.readDoubleFromXML(child);
                continue;
            }
            if (name.equals(VAL_Y)) {
                y = this.readDoubleFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new Point();
        result.setLocation(x, y);
        return result;
    }

    public Element writeColorUIResource(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        ColorUIResource resource = (ColorUIResource)o;
        Element node = this.addElement(parent, name, resource.getClass().getName(), false);
        this.invokeWriteToXML(node, new Color(resource.getRGB()), VAL_COLOR);
        return node;
    }

    public Object readColorUIResource(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        ColorUIResource result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        Color color = null;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_COLOR)) {
                color = (Color)this.invokeReadFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new ColorUIResource(color);
        return result;
    }

    public Element writeFontUIResource(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        FontUIResource resource = (FontUIResource)o;
        Element node = this.addElement(parent, name, resource.getClass().getName(), false);
        this.invokeWriteToXML(node, new Font(resource.getName(), resource.getStyle(), resource.getSize()), VAL_COLOR);
        return node;
    }

    public Object readFontUIResource(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        FontUIResource result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        Font font = null;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_FONT)) {
                font = (Font)this.invokeReadFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new FontUIResource(font);
        return result;
    }

    public Element writeBeanInstance(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        BeanInstance beaninst = (BeanInstance)o;
        Element node = this.addElement(parent, name, beaninst.getClass().getName(), false);
        this.writeIntToXML(node, this.m_BeanInstances.indexOf(beaninst), VAL_ID);
        this.writeIntToXML(node, beaninst.getX() + beaninst.getWidth() / 2, VAL_X);
        this.writeIntToXML(node, beaninst.getY() + beaninst.getHeight() / 2, VAL_Y);
        if (beaninst.getBean() instanceof BeanCommon) {
            String custName = ((BeanCommon)beaninst.getBean()).getCustomName();
            this.invokeWriteToXML(node, custName, VAL_CUSTOM_NAME);
        }
        this.invokeWriteToXML(node, beaninst.getBean(), VAL_BEAN);
        return node;
    }

    public Object readBeanInstance(Element node) throws Exception {
        int i;
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        BeanInstance result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        int id = -1;
        int x = 0;
        int y = 0;
        Object bean = null;
        String customName = null;
        for (i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_ID)) {
                id = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_X)) {
                x = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_Y)) {
                y = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_CUSTOM_NAME)) {
                customName = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_BEAN)) {
                bean = this.invokeReadFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        result = new BeanInstance(this.m_BeanLayout, bean, x, y);
        BeanInstance beaninst = result;
        if (beaninst.getBean() instanceof Visible) {
            BeanVisual visual = ((Visible)beaninst.getBean()).getVisual();
            visual.setSize(visual.getPreferredSize());
            if (visual.getParent() == null) {
                ((JPanel)beaninst.getBean()).add(visual);
            }
        }
        if (beaninst.getBean() instanceof BeanCommon && customName != null) {
            ((BeanCommon)beaninst.getBean()).setCustomName(customName);
        }
        if (id == -1) {
            for (i = 0; i < this.m_BeanInstances.size(); ++i) {
                if (this.m_BeanInstances.get(i) != null) continue;
                id = (Integer)this.m_BeanInstancesID.get(i);
                break;
            }
        }
        i = this.m_BeanInstancesID.indexOf(new Integer(id));
        this.m_BeanInstances.set(i, result);
        this.m_CurrentMetaBean = null;
        return result;
    }

    public Element writeBeanConnection(Element parent, Object o, String name) throws Exception {
        int target;
        int source;
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        BeanConnection beanconn = (BeanConnection)o;
        Element node = null;
        int sourcePos = this.m_BeanInstances.indexOf(beanconn.getSource());
        int targetPos = this.m_BeanInstances.indexOf(beanconn.getTarget());
        if (sourcePos > -1 && targetPos > -1) {
            source = (Integer)this.m_BeanInstancesID.get(sourcePos);
            target = (Integer)this.m_BeanInstancesID.get(targetPos);
        } else {
            source = -1;
            target = -1;
        }
        if (source > -1 && target > -1) {
            node = this.addElement(parent, name, beanconn.getClass().getName(), false);
            this.writeIntToXML(node, source, VAL_SOURCEID);
            this.writeIntToXML(node, target, VAL_TARGETID);
            this.invokeWriteToXML(node, beanconn.getEventName(), VAL_EVENTNAME);
            this.writeBooleanToXML(node, beanconn.isHidden(), VAL_HIDDEN);
        }
        return node;
    }

    public Object readBeanConnection(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        BeanConnection result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        int source = 0;
        int target = 0;
        String event = "";
        boolean hidden = false;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_SOURCEID)) {
                source = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_TARGETID)) {
                target = this.readIntFromXML(child);
                continue;
            }
            if (name.equals(VAL_EVENTNAME)) {
                event = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_HIDDEN)) {
                hidden = this.readBooleanFromXML(child);
                continue;
            }
            System.out.println("WARNING: '" + name + "' is not a recognized name for " + node.getAttribute(VAL_NAME) + "!");
        }
        int sourcePos = this.m_BeanInstancesID.indexOf(new Integer(source));
        int targetPos = this.m_BeanInstancesID.indexOf(new Integer(target));
        if (this.m_IgnoreBeanConnections) {
            this.addBeanConnectionRelation(this.m_CurrentMetaBean, sourcePos + "," + targetPos + "," + event + "," + hidden);
            return result;
        }
        result = this.createBeanConnection(sourcePos, targetPos, event, hidden);
        return result;
    }

    public Element writeBeanLoader(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Loader loader = (Loader)o;
        Element node = this.addElement(parent, name, loader.getClass().getName(), false);
        this.invokeWriteToXML(node, loader.getLoader(), "wrappedAlgorithm");
        this.invokeWriteToXML(node, loader.getBeanContext(), VAL_BEANCONTEXT);
        return node;
    }

    public Element writeBeanSaver(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Saver saver = (Saver)o;
        Element node = this.addElement(parent, name, saver.getClass().getName(), false);
        this.invokeWriteToXML(node, saver.getRelationNameForFilename(), VAL_RELATIONNAMEFORFILENAME);
        this.invokeWriteToXML(node, saver.getSaverTemplate(), "wrappedAlgorithm");
        return node;
    }

    public Element writeLoader(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        weka.core.converters.Loader loader = (weka.core.converters.Loader)o;
        Element node = this.addElement(parent, name, loader.getClass().getName(), false);
        boolean known = true;
        File file = null;
        if (loader instanceof AbstractFileLoader) {
            file = ((AbstractFileLoader)loader).retrieveFile();
        } else {
            known = false;
        }
        if (!known) {
            System.out.println("WARNING: unknown loader class '" + loader.getClass().getName() + "' - cannot retrieve file!");
        }
        Boolean relativeB = null;
        if (loader instanceof FileSourcedConverter) {
            boolean relative = ((FileSourcedConverter)((Object)loader)).getUseRelativePath();
            relativeB = new Boolean(relative);
        }
        if (file == null || file.isDirectory()) {
            this.invokeWriteToXML(node, "", VAL_FILE);
        } else {
            boolean notAbsolute = ((AbstractFileLoader)loader).getUseRelativePath() || loader instanceof EnvironmentHandler && Environment.containsEnvVariables(file.getPath());
            String path = notAbsolute ? file.getPath() : file.getAbsolutePath();
            path = path.replace('\\', '/');
            this.invokeWriteToXML(node, path, VAL_FILE);
        }
        if (relativeB != null) {
            this.invokeWriteToXML(node, relativeB.toString(), VAL_RELATIVE_PATH);
        }
        return node;
    }

    public Object readLoader(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Object result = Class.forName(node.getAttribute("class")).newInstance();
        Vector<Element> children = XMLDocument.getChildTags(node);
        String file = "";
        Object relativeB = null;
        boolean relative = false;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_FILE)) {
                file = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_RELATIVE_PATH)) {
                relativeB = this.readFromXML(child);
                if (!(relativeB instanceof Boolean)) continue;
                relative = (Boolean)relativeB;
                continue;
            }
            this.readFromXML(result, name, child);
        }
        if (result instanceof FileSourcedConverter) {
            ((FileSourcedConverter)result).setUseRelativePath(relative);
        }
        if (file.equals("")) {
            file = null;
        }
        if (file != null) {
            String tempFile = file;
            boolean containsEnv = false;
            containsEnv = Environment.containsEnvVariables(file);
            File fl = new File(file);
            if (containsEnv || fl.exists()) {
                ((AbstractFileLoader)result).setSource(new File(file));
            } else {
                System.out.println("WARNING: The file '" + tempFile + "' does not exist!");
            }
        }
        return result;
    }

    public Element writeSaver(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        weka.core.converters.Saver saver = (weka.core.converters.Saver)o;
        Element node = this.addElement(parent, name, saver.getClass().getName(), false);
        boolean known = true;
        File file = null;
        String prefix = "";
        String dir = "";
        if (saver instanceof AbstractFileSaver) {
            file = ((AbstractFileSaver)saver).retrieveFile();
            prefix = ((AbstractFileSaver)saver).filePrefix();
            dir = ((AbstractFileSaver)saver).retrieveDir();
            dir = dir.replace('\\', '/');
        } else {
            known = false;
        }
        if (!known) {
            System.out.println("WARNING: unknown saver class '" + saver.getClass().getName() + "' - cannot retrieve file!");
        }
        Boolean relativeB = null;
        if (saver instanceof FileSourcedConverter) {
            boolean relative = ((FileSourcedConverter)((Object)saver)).getUseRelativePath();
            relativeB = new Boolean(relative);
        }
        this.invokeWriteToXML(node, "", VAL_FILE);
        this.invokeWriteToXML(node, dir, VAL_DIR);
        this.invokeWriteToXML(node, prefix, VAL_PREFIX);
        if (relativeB != null) {
            this.invokeWriteToXML(node, relativeB.toString(), VAL_RELATIVE_PATH);
        }
        return node;
    }

    public Object readSaver(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        Object result = Class.forName(node.getAttribute("class")).newInstance();
        Vector<Element> children = XMLDocument.getChildTags(node);
        String file = null;
        String dir = null;
        String prefix = null;
        Object relativeB = null;
        boolean relative = false;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_FILE)) {
                file = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_DIR)) {
                dir = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_PREFIX)) {
                prefix = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_RELATIVE_PATH)) {
                relativeB = this.readFromXML(child);
                if (!(relativeB instanceof Boolean)) continue;
                relative = (Boolean)relativeB;
                continue;
            }
            this.readFromXML(result, name, child);
        }
        if (file != null && file.length() == 0) {
            file = null;
        }
        if (dir != null && prefix != null) {
            ((AbstractFileSaver)result).setDir(dir);
            ((AbstractFileSaver)result).setFilePrefix(prefix);
        }
        if (result instanceof FileSourcedConverter) {
            ((FileSourcedConverter)result).setUseRelativePath(relative);
        }
        return result;
    }

    public Element writeBeanVisual(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        BeanVisual visual = (BeanVisual)o;
        Element node = this.writeToXML(parent, o, name);
        this.invokeWriteToXML(node, visual.getIconPath(), VAL_ICONPATH);
        this.invokeWriteToXML(node, visual.getAnimatedIconPath(), VAL_ANIMATEDICONPATH);
        return node;
    }

    public Object readBeanVisual(Element node) throws Exception {
        int i;
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        BeanVisual result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        String text = "";
        String iconPath = "";
        String animIconPath = "";
        for (i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_TEXT)) {
                text = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_ICONPATH)) {
                iconPath = (String)this.invokeReadFromXML(child);
                continue;
            }
            if (!name.equals(VAL_ANIMATEDICONPATH)) continue;
            animIconPath = (String)this.invokeReadFromXML(child);
        }
        result = new BeanVisual(text, iconPath, animIconPath);
        for (i = 0; i < children.size(); ++i) {
            this.readFromXML(result, node.getAttribute(VAL_NAME), children.get(i));
        }
        return result;
    }

    protected Vector getIDsForBeanInstances(Vector beans) {
        Vector result = new Vector();
        for (int i = 0; i < beans.size(); ++i) {
            int pos = this.m_BeanInstances.indexOf(beans.get(i));
            result.add(this.m_BeanInstancesID.get(pos));
        }
        return result;
    }

    public Element writeMetaBean(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        MetaBean meta = (MetaBean)o;
        Element node = this.writeToXML(parent, o, name);
        this.invokeWriteToXML(node, this.getIDsForBeanInstances(meta.getBeansInInputs()), VAL_INPUTSID);
        this.invokeWriteToXML(node, this.getIDsForBeanInstances(meta.getBeansInOutputs()), VAL_OUTPUTSID);
        return node;
    }

    protected Vector getBeanInstancesForIDs(Vector ids) {
        Vector result = new Vector();
        for (int i = 0; i < ids.size(); ++i) {
            int pos = this.m_BeanInstancesID.indexOf(ids.get(i));
            result.add(this.m_BeanInstances.get(pos));
        }
        return result;
    }

    public Object readMetaBean(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = node;
        MetaBean result = new MetaBean();
        Vector<Element> children = XMLDocument.getChildTags(node);
        Vector inputs = new Vector();
        Vector outputs = new Vector();
        Vector coords = new Vector();
        this.m_CurrentMetaBean = result;
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute(VAL_NAME);
            if (name.equals(VAL_ASSOCIATEDCONNECTIONS)) {
                result.setAssociatedConnections((Vector)this.invokeReadFromXML(child));
                continue;
            }
            if (name.equals(VAL_INPUTSID)) {
                inputs = (Vector)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_OUTPUTSID)) {
                outputs = (Vector)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_SUBFLOW)) {
                result.setSubFlow((Vector)this.invokeReadFromXML(child));
                continue;
            }
            if (name.equals(VAL_ORIGINALCOORDS)) {
                coords = (Vector)this.invokeReadFromXML(child);
                continue;
            }
            if (name.equals(VAL_INPUTS)) {
                System.out.println("INFO: '" + name + "' will be restored later.");
                continue;
            }
            if (name.equals(VAL_OUTPUTS)) {
                System.out.println("INFO: '" + name + "' will be restored later.");
                continue;
            }
            this.readFromXML(result, name, child);
        }
        MetaBean bean = result;
        bean.setInputs(this.getBeanInstancesForIDs(inputs));
        bean.setOutputs(this.getBeanInstancesForIDs(outputs));
        bean.setOriginalCoords(coords);
        return result;
    }
}

